/*
Pulp 3 API

Fetch, Upload, Organize, and Distribute Software Packages

API version: v3
Contact: pulp-list@redhat.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package pulpclient

import (
	"encoding/json"
	"time"
)

// checks if the RpmRpmPublicationResponse type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &RpmRpmPublicationResponse{}

// RpmRpmPublicationResponse A Serializer for RpmPublication.
type RpmRpmPublicationResponse struct {
	PulpHref *string `json:"pulp_href,omitempty"`
	// Timestamp of creation.
	PulpCreated *time.Time `json:"pulp_created,omitempty"`
	RepositoryVersion *string `json:"repository_version,omitempty"`
	// A URI of the repository to be published.
	Repository *string `json:"repository,omitempty"`
	MetadataChecksumType *MetadataChecksumTypeEnum `json:"metadata_checksum_type,omitempty"`
	PackageChecksumType *PackageChecksumTypeEnum `json:"package_checksum_type,omitempty"`
	// An option specifying whether a client should perform a GPG signature check on packages.
	Gpgcheck *int64 `json:"gpgcheck,omitempty"`
	// An option specifying whether a client should perform a GPG signature check on the repodata.
	RepoGpgcheck *int64 `json:"repo_gpgcheck,omitempty"`
	// DEPRECATED: An option specifying whether Pulp should generate SQLite metadata.
	SqliteMetadata *bool `json:"sqlite_metadata,omitempty"`
	AdditionalProperties map[string]interface{}
}

type _RpmRpmPublicationResponse RpmRpmPublicationResponse

// NewRpmRpmPublicationResponse instantiates a new RpmRpmPublicationResponse object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewRpmRpmPublicationResponse() *RpmRpmPublicationResponse {
	this := RpmRpmPublicationResponse{}
	var sqliteMetadata bool = false
	this.SqliteMetadata = &sqliteMetadata
	return &this
}

// NewRpmRpmPublicationResponseWithDefaults instantiates a new RpmRpmPublicationResponse object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewRpmRpmPublicationResponseWithDefaults() *RpmRpmPublicationResponse {
	this := RpmRpmPublicationResponse{}
	var sqliteMetadata bool = false
	this.SqliteMetadata = &sqliteMetadata
	return &this
}

// GetPulpHref returns the PulpHref field value if set, zero value otherwise.
func (o *RpmRpmPublicationResponse) GetPulpHref() string {
	if o == nil || IsNil(o.PulpHref) {
		var ret string
		return ret
	}
	return *o.PulpHref
}

// GetPulpHrefOk returns a tuple with the PulpHref field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *RpmRpmPublicationResponse) GetPulpHrefOk() (*string, bool) {
	if o == nil || IsNil(o.PulpHref) {
		return nil, false
	}
	return o.PulpHref, true
}

// HasPulpHref returns a boolean if a field has been set.
func (o *RpmRpmPublicationResponse) HasPulpHref() bool {
	if o != nil && !IsNil(o.PulpHref) {
		return true
	}

	return false
}

// SetPulpHref gets a reference to the given string and assigns it to the PulpHref field.
func (o *RpmRpmPublicationResponse) SetPulpHref(v string) {
	o.PulpHref = &v
}

// GetPulpCreated returns the PulpCreated field value if set, zero value otherwise.
func (o *RpmRpmPublicationResponse) GetPulpCreated() time.Time {
	if o == nil || IsNil(o.PulpCreated) {
		var ret time.Time
		return ret
	}
	return *o.PulpCreated
}

// GetPulpCreatedOk returns a tuple with the PulpCreated field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *RpmRpmPublicationResponse) GetPulpCreatedOk() (*time.Time, bool) {
	if o == nil || IsNil(o.PulpCreated) {
		return nil, false
	}
	return o.PulpCreated, true
}

// HasPulpCreated returns a boolean if a field has been set.
func (o *RpmRpmPublicationResponse) HasPulpCreated() bool {
	if o != nil && !IsNil(o.PulpCreated) {
		return true
	}

	return false
}

// SetPulpCreated gets a reference to the given time.Time and assigns it to the PulpCreated field.
func (o *RpmRpmPublicationResponse) SetPulpCreated(v time.Time) {
	o.PulpCreated = &v
}

// GetRepositoryVersion returns the RepositoryVersion field value if set, zero value otherwise.
func (o *RpmRpmPublicationResponse) GetRepositoryVersion() string {
	if o == nil || IsNil(o.RepositoryVersion) {
		var ret string
		return ret
	}
	return *o.RepositoryVersion
}

// GetRepositoryVersionOk returns a tuple with the RepositoryVersion field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *RpmRpmPublicationResponse) GetRepositoryVersionOk() (*string, bool) {
	if o == nil || IsNil(o.RepositoryVersion) {
		return nil, false
	}
	return o.RepositoryVersion, true
}

// HasRepositoryVersion returns a boolean if a field has been set.
func (o *RpmRpmPublicationResponse) HasRepositoryVersion() bool {
	if o != nil && !IsNil(o.RepositoryVersion) {
		return true
	}

	return false
}

// SetRepositoryVersion gets a reference to the given string and assigns it to the RepositoryVersion field.
func (o *RpmRpmPublicationResponse) SetRepositoryVersion(v string) {
	o.RepositoryVersion = &v
}

// GetRepository returns the Repository field value if set, zero value otherwise.
func (o *RpmRpmPublicationResponse) GetRepository() string {
	if o == nil || IsNil(o.Repository) {
		var ret string
		return ret
	}
	return *o.Repository
}

// GetRepositoryOk returns a tuple with the Repository field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *RpmRpmPublicationResponse) GetRepositoryOk() (*string, bool) {
	if o == nil || IsNil(o.Repository) {
		return nil, false
	}
	return o.Repository, true
}

// HasRepository returns a boolean if a field has been set.
func (o *RpmRpmPublicationResponse) HasRepository() bool {
	if o != nil && !IsNil(o.Repository) {
		return true
	}

	return false
}

// SetRepository gets a reference to the given string and assigns it to the Repository field.
func (o *RpmRpmPublicationResponse) SetRepository(v string) {
	o.Repository = &v
}

// GetMetadataChecksumType returns the MetadataChecksumType field value if set, zero value otherwise.
func (o *RpmRpmPublicationResponse) GetMetadataChecksumType() MetadataChecksumTypeEnum {
	if o == nil || IsNil(o.MetadataChecksumType) {
		var ret MetadataChecksumTypeEnum
		return ret
	}
	return *o.MetadataChecksumType
}

// GetMetadataChecksumTypeOk returns a tuple with the MetadataChecksumType field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *RpmRpmPublicationResponse) GetMetadataChecksumTypeOk() (*MetadataChecksumTypeEnum, bool) {
	if o == nil || IsNil(o.MetadataChecksumType) {
		return nil, false
	}
	return o.MetadataChecksumType, true
}

// HasMetadataChecksumType returns a boolean if a field has been set.
func (o *RpmRpmPublicationResponse) HasMetadataChecksumType() bool {
	if o != nil && !IsNil(o.MetadataChecksumType) {
		return true
	}

	return false
}

// SetMetadataChecksumType gets a reference to the given MetadataChecksumTypeEnum and assigns it to the MetadataChecksumType field.
func (o *RpmRpmPublicationResponse) SetMetadataChecksumType(v MetadataChecksumTypeEnum) {
	o.MetadataChecksumType = &v
}

// GetPackageChecksumType returns the PackageChecksumType field value if set, zero value otherwise.
func (o *RpmRpmPublicationResponse) GetPackageChecksumType() PackageChecksumTypeEnum {
	if o == nil || IsNil(o.PackageChecksumType) {
		var ret PackageChecksumTypeEnum
		return ret
	}
	return *o.PackageChecksumType
}

// GetPackageChecksumTypeOk returns a tuple with the PackageChecksumType field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *RpmRpmPublicationResponse) GetPackageChecksumTypeOk() (*PackageChecksumTypeEnum, bool) {
	if o == nil || IsNil(o.PackageChecksumType) {
		return nil, false
	}
	return o.PackageChecksumType, true
}

// HasPackageChecksumType returns a boolean if a field has been set.
func (o *RpmRpmPublicationResponse) HasPackageChecksumType() bool {
	if o != nil && !IsNil(o.PackageChecksumType) {
		return true
	}

	return false
}

// SetPackageChecksumType gets a reference to the given PackageChecksumTypeEnum and assigns it to the PackageChecksumType field.
func (o *RpmRpmPublicationResponse) SetPackageChecksumType(v PackageChecksumTypeEnum) {
	o.PackageChecksumType = &v
}

// GetGpgcheck returns the Gpgcheck field value if set, zero value otherwise.
func (o *RpmRpmPublicationResponse) GetGpgcheck() int64 {
	if o == nil || IsNil(o.Gpgcheck) {
		var ret int64
		return ret
	}
	return *o.Gpgcheck
}

// GetGpgcheckOk returns a tuple with the Gpgcheck field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *RpmRpmPublicationResponse) GetGpgcheckOk() (*int64, bool) {
	if o == nil || IsNil(o.Gpgcheck) {
		return nil, false
	}
	return o.Gpgcheck, true
}

// HasGpgcheck returns a boolean if a field has been set.
func (o *RpmRpmPublicationResponse) HasGpgcheck() bool {
	if o != nil && !IsNil(o.Gpgcheck) {
		return true
	}

	return false
}

// SetGpgcheck gets a reference to the given int64 and assigns it to the Gpgcheck field.
func (o *RpmRpmPublicationResponse) SetGpgcheck(v int64) {
	o.Gpgcheck = &v
}

// GetRepoGpgcheck returns the RepoGpgcheck field value if set, zero value otherwise.
func (o *RpmRpmPublicationResponse) GetRepoGpgcheck() int64 {
	if o == nil || IsNil(o.RepoGpgcheck) {
		var ret int64
		return ret
	}
	return *o.RepoGpgcheck
}

// GetRepoGpgcheckOk returns a tuple with the RepoGpgcheck field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *RpmRpmPublicationResponse) GetRepoGpgcheckOk() (*int64, bool) {
	if o == nil || IsNil(o.RepoGpgcheck) {
		return nil, false
	}
	return o.RepoGpgcheck, true
}

// HasRepoGpgcheck returns a boolean if a field has been set.
func (o *RpmRpmPublicationResponse) HasRepoGpgcheck() bool {
	if o != nil && !IsNil(o.RepoGpgcheck) {
		return true
	}

	return false
}

// SetRepoGpgcheck gets a reference to the given int64 and assigns it to the RepoGpgcheck field.
func (o *RpmRpmPublicationResponse) SetRepoGpgcheck(v int64) {
	o.RepoGpgcheck = &v
}

// GetSqliteMetadata returns the SqliteMetadata field value if set, zero value otherwise.
func (o *RpmRpmPublicationResponse) GetSqliteMetadata() bool {
	if o == nil || IsNil(o.SqliteMetadata) {
		var ret bool
		return ret
	}
	return *o.SqliteMetadata
}

// GetSqliteMetadataOk returns a tuple with the SqliteMetadata field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *RpmRpmPublicationResponse) GetSqliteMetadataOk() (*bool, bool) {
	if o == nil || IsNil(o.SqliteMetadata) {
		return nil, false
	}
	return o.SqliteMetadata, true
}

// HasSqliteMetadata returns a boolean if a field has been set.
func (o *RpmRpmPublicationResponse) HasSqliteMetadata() bool {
	if o != nil && !IsNil(o.SqliteMetadata) {
		return true
	}

	return false
}

// SetSqliteMetadata gets a reference to the given bool and assigns it to the SqliteMetadata field.
func (o *RpmRpmPublicationResponse) SetSqliteMetadata(v bool) {
	o.SqliteMetadata = &v
}

func (o RpmRpmPublicationResponse) MarshalJSON() ([]byte, error) {
	toSerialize,err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o RpmRpmPublicationResponse) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	if !IsNil(o.PulpHref) {
		toSerialize["pulp_href"] = o.PulpHref
	}
	if !IsNil(o.PulpCreated) {
		toSerialize["pulp_created"] = o.PulpCreated
	}
	if !IsNil(o.RepositoryVersion) {
		toSerialize["repository_version"] = o.RepositoryVersion
	}
	if !IsNil(o.Repository) {
		toSerialize["repository"] = o.Repository
	}
	if !IsNil(o.MetadataChecksumType) {
		toSerialize["metadata_checksum_type"] = o.MetadataChecksumType
	}
	if !IsNil(o.PackageChecksumType) {
		toSerialize["package_checksum_type"] = o.PackageChecksumType
	}
	if !IsNil(o.Gpgcheck) {
		toSerialize["gpgcheck"] = o.Gpgcheck
	}
	if !IsNil(o.RepoGpgcheck) {
		toSerialize["repo_gpgcheck"] = o.RepoGpgcheck
	}
	if !IsNil(o.SqliteMetadata) {
		toSerialize["sqlite_metadata"] = o.SqliteMetadata
	}

	for key, value := range o.AdditionalProperties {
		toSerialize[key] = value
	}

	return toSerialize, nil
}

func (o *RpmRpmPublicationResponse) UnmarshalJSON(bytes []byte) (err error) {
	varRpmRpmPublicationResponse := _RpmRpmPublicationResponse{}

	if err = json.Unmarshal(bytes, &varRpmRpmPublicationResponse); err == nil {
		*o = RpmRpmPublicationResponse(varRpmRpmPublicationResponse)
	}

	additionalProperties := make(map[string]interface{})

	if err = json.Unmarshal(bytes, &additionalProperties); err == nil {
		delete(additionalProperties, "pulp_href")
		delete(additionalProperties, "pulp_created")
		delete(additionalProperties, "repository_version")
		delete(additionalProperties, "repository")
		delete(additionalProperties, "metadata_checksum_type")
		delete(additionalProperties, "package_checksum_type")
		delete(additionalProperties, "gpgcheck")
		delete(additionalProperties, "repo_gpgcheck")
		delete(additionalProperties, "sqlite_metadata")
		o.AdditionalProperties = additionalProperties
	}

	return err
}

type NullableRpmRpmPublicationResponse struct {
	value *RpmRpmPublicationResponse
	isSet bool
}

func (v NullableRpmRpmPublicationResponse) Get() *RpmRpmPublicationResponse {
	return v.value
}

func (v *NullableRpmRpmPublicationResponse) Set(val *RpmRpmPublicationResponse) {
	v.value = val
	v.isSet = true
}

func (v NullableRpmRpmPublicationResponse) IsSet() bool {
	return v.isSet
}

func (v *NullableRpmRpmPublicationResponse) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableRpmRpmPublicationResponse(val *RpmRpmPublicationResponse) *NullableRpmRpmPublicationResponse {
	return &NullableRpmRpmPublicationResponse{value: val, isSet: true}
}

func (v NullableRpmRpmPublicationResponse) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableRpmRpmPublicationResponse) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


