/*
Pulp 3 API

Fetch, Upload, Organize, and Distribute Software Packages

API version: v3
Contact: pulp-list@redhat.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package pulpclient

import (
	"encoding/json"
)

// checks if the SummaryResponse type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &SummaryResponse{}

// SummaryResponse A Serializer for summary information of an index.
type SummaryResponse struct {
	// Number of Python projects in index
	Projects int64 `json:"projects"`
	// Number of Python distribution releases in index
	Releases int64 `json:"releases"`
	// Number of files for all distributions in index
	Files int64 `json:"files"`
	AdditionalProperties map[string]interface{}
}

type _SummaryResponse SummaryResponse

// NewSummaryResponse instantiates a new SummaryResponse object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewSummaryResponse(projects int64, releases int64, files int64) *SummaryResponse {
	this := SummaryResponse{}
	this.Projects = projects
	this.Releases = releases
	this.Files = files
	return &this
}

// NewSummaryResponseWithDefaults instantiates a new SummaryResponse object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewSummaryResponseWithDefaults() *SummaryResponse {
	this := SummaryResponse{}
	return &this
}

// GetProjects returns the Projects field value
func (o *SummaryResponse) GetProjects() int64 {
	if o == nil {
		var ret int64
		return ret
	}

	return o.Projects
}

// GetProjectsOk returns a tuple with the Projects field value
// and a boolean to check if the value has been set.
func (o *SummaryResponse) GetProjectsOk() (*int64, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Projects, true
}

// SetProjects sets field value
func (o *SummaryResponse) SetProjects(v int64) {
	o.Projects = v
}

// GetReleases returns the Releases field value
func (o *SummaryResponse) GetReleases() int64 {
	if o == nil {
		var ret int64
		return ret
	}

	return o.Releases
}

// GetReleasesOk returns a tuple with the Releases field value
// and a boolean to check if the value has been set.
func (o *SummaryResponse) GetReleasesOk() (*int64, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Releases, true
}

// SetReleases sets field value
func (o *SummaryResponse) SetReleases(v int64) {
	o.Releases = v
}

// GetFiles returns the Files field value
func (o *SummaryResponse) GetFiles() int64 {
	if o == nil {
		var ret int64
		return ret
	}

	return o.Files
}

// GetFilesOk returns a tuple with the Files field value
// and a boolean to check if the value has been set.
func (o *SummaryResponse) GetFilesOk() (*int64, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Files, true
}

// SetFiles sets field value
func (o *SummaryResponse) SetFiles(v int64) {
	o.Files = v
}

func (o SummaryResponse) MarshalJSON() ([]byte, error) {
	toSerialize,err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o SummaryResponse) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	toSerialize["projects"] = o.Projects
	toSerialize["releases"] = o.Releases
	toSerialize["files"] = o.Files

	for key, value := range o.AdditionalProperties {
		toSerialize[key] = value
	}

	return toSerialize, nil
}

func (o *SummaryResponse) UnmarshalJSON(bytes []byte) (err error) {
	varSummaryResponse := _SummaryResponse{}

	if err = json.Unmarshal(bytes, &varSummaryResponse); err == nil {
		*o = SummaryResponse(varSummaryResponse)
	}

	additionalProperties := make(map[string]interface{})

	if err = json.Unmarshal(bytes, &additionalProperties); err == nil {
		delete(additionalProperties, "projects")
		delete(additionalProperties, "releases")
		delete(additionalProperties, "files")
		o.AdditionalProperties = additionalProperties
	}

	return err
}

type NullableSummaryResponse struct {
	value *SummaryResponse
	isSet bool
}

func (v NullableSummaryResponse) Get() *SummaryResponse {
	return v.value
}

func (v *NullableSummaryResponse) Set(val *SummaryResponse) {
	v.value = val
	v.isSet = true
}

func (v NullableSummaryResponse) IsSet() bool {
	return v.isSet
}

func (v *NullableSummaryResponse) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableSummaryResponse(val *SummaryResponse) *NullableSummaryResponse {
	return &NullableSummaryResponse{value: val, isSet: true}
}

func (v NullableSummaryResponse) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableSummaryResponse) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


