/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.legacy.server.policy.constraints;

import com.netscape.certsrv.base.IExtendedPluginInfo;
import com.netscape.certsrv.request.PolicyResult;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.request.Request;
import java.util.Vector;
import org.dogtagpki.legacy.policy.EPolicyException;
import org.dogtagpki.legacy.policy.IEnrollmentPolicy;
import org.dogtagpki.legacy.policy.IPolicyProcessor;
import org.dogtagpki.legacy.server.policy.APolicyRule;
import org.mozilla.jss.netscape.security.x509.X500Name;
import org.mozilla.jss.netscape.security.x509.X509CertInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IssuerConstraints
extends APolicyRule
implements IEnrollmentPolicy,
IExtendedPluginInfo {
    public static Logger logger = LoggerFactory.getLogger(IssuerConstraints.class);
    private static final String PROP_ISSUER_DN = "issuerDN";
    private static final String CLIENT_ISSUER = "clientIssuer";
    private X500Name mIssuerDN = null;
    private String mIssuerDNString;

    public IssuerConstraints() {
        this.NAME = "IssuerConstraints";
        this.DESC = "Checks to see if the Issuer is one allowed";
    }

    public String[] getExtendedPluginInfo() {
        String[] params = new String[]{"issuerDN;string;Subject DN of the Issuer. The IssuerDN of the authenticating cert must match what's specified here", "HELP_TOKEN;configuration-policyrules-issuerconstraints", "HELP_TEXT;Rejects the request if the issuer in the certificate isnot of the one specified"};
        return params;
    }

    public void init(IPolicyProcessor owner, ConfigStore config) throws EPolicyException {
        try {
            this.mIssuerDNString = config.getString(PROP_ISSUER_DN, null);
            if (this.mIssuerDNString != null && !this.mIssuerDNString.equals("")) {
                this.mIssuerDN = new X500Name(this.mIssuerDNString);
            }
        }
        catch (Exception e) {
            logger.error(this.NAME + CMS.getLogMessage((String)"CA_GET_ISSUER_NAME_FAILED", (Object[])new Object[0]), (Throwable)e);
            String[] params = new String[]{this.getInstanceName(), e.toString()};
            throw new EPolicyException(CMS.getUserMessage((String)"CMS_POLICY_INVALID_POLICY_CONFIG", (String[])params), e);
        }
        logger.debug(this.NAME + ": init() done");
    }

    public PolicyResult apply(Request req) {
        PolicyResult result = PolicyResult.ACCEPTED;
        if (this.mIssuerDN == null) {
            return result;
        }
        try {
            String clientIssuerDN = req.getExtDataInString(CLIENT_ISSUER);
            if (clientIssuerDN != null) {
                X500Name ci_name = new X500Name(clientIssuerDN);
                if (!ci_name.equals((Object)this.mIssuerDN)) {
                    this.setError(req, CMS.getUserMessage((String)"CMS_POLICY_INVALID_ISSUER", (String[])new String[]{this.getInstanceName()}), "");
                    result = PolicyResult.REJECTED;
                    logger.warn(CMS.getLogMessage((String)"CA_GET_ISSUER_NAME_FAILED", (Object[])new Object[0]));
                    logger.debug(this.NAME + ": apply() - issuerDN mismatch: client issuerDN = " + clientIssuerDN + "; expected issuerDN = " + this.mIssuerDNString);
                }
            } else {
                X509CertInfo[] certInfo = req.getExtDataInCertInfoArray("CERT_INFO");
                if (certInfo == null) {
                    logger.warn(this.NAME + ": apply() - missing certInfo");
                    this.setError(req, CMS.getUserMessage((String)"CMS_POLICY_NO_CERT_INFO", (String[])new String[]{this.getInstanceName()}), "");
                    return PolicyResult.REJECTED;
                }
                for (int i = 0; i < certInfo.length; ++i) {
                    X500Name oi_name;
                    String oldIssuer = certInfo[i].get("issuer").toString();
                    if (oldIssuer == null) {
                        this.setError(req, CMS.getUserMessage((String)"CMS_POLICY_CLIENT_ISSUER_NOT_FOUND", (String[])new String[]{this.getInstanceName()}), "");
                        result = PolicyResult.REJECTED;
                        logger.warn(this.NAME + ": apply() - client issuerDN not found");
                    }
                    if ((oi_name = new X500Name(oldIssuer)).equals((Object)this.mIssuerDN)) continue;
                    this.setError(req, CMS.getUserMessage((String)"CMS_POLICY_INVALID_ISSUER", (String[])new String[]{this.getInstanceName()}), "");
                    result = PolicyResult.REJECTED;
                    logger.warn(this.NAME + ": apply() - cert issuerDN mismatch: client issuerDN = " + oldIssuer + "; expected issuerDN = " + this.mIssuerDNString);
                }
            }
        }
        catch (Exception e) {
            String[] params = new String[]{this.getInstanceName(), e.toString()};
            this.setError(req, CMS.getUserMessage((String)"CMS_POLICY_UNEXPECTED_POLICY_ERROR", (String[])params), "");
            result = PolicyResult.REJECTED;
        }
        if (result.equals(PolicyResult.ACCEPTED)) {
            logger.info(this.NAME + ": apply() - accepted");
        }
        return result;
    }

    public Vector<String> getInstanceParams() {
        Vector<String> confParams = new Vector<String>();
        confParams.addElement("issuerDN=" + this.mIssuerDNString);
        return confParams;
    }

    public Vector<String> getDefaultParams() {
        Vector<String> defParams = new Vector<String>();
        defParams.addElement("issuerDN=");
        return defParams;
    }
}

