/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.kra;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.dbs.keydb.KeyId;
import com.netscape.certsrv.logging.LogEvent;
import com.netscape.certsrv.logging.event.SecurityDataRecoveryProcessedEvent;
import com.netscape.certsrv.request.IService;
import com.netscape.certsrv.request.RequestId;
import com.netscape.cmscore.logging.Auditor;
import com.netscape.cmscore.request.Request;
import com.netscape.kra.KeyRecoveryAuthority;
import com.netscape.kra.SecurityDataProcessor;
import java.math.BigInteger;
import org.dogtagpki.server.kra.KRAEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityDataRecoveryService
implements IService {
    public static Logger logger = LoggerFactory.getLogger(SecurityDataRecoveryService.class);
    private SecurityDataProcessor processor = null;

    public SecurityDataRecoveryService(KeyRecoveryAuthority kra) {
        this.processor = new SecurityDataProcessor(kra);
    }

    public boolean serviceRequest(Request request) throws EBaseException {
        logger.debug("SecurityDataRecoveryService.serviceRequest()");
        String auditSubjectID = request.getExtDataInString("requestOwner");
        BigInteger serialNumber = request.getExtDataInBigInteger("serialNumber");
        KeyId keyId = serialNumber != null ? new KeyId(serialNumber) : null;
        RequestId requestID = request.getRequestId();
        String approvers = request.getExtDataInString("approvingAgents");
        KRAEngine engine = KRAEngine.getInstance();
        Auditor auditor = engine.getAuditor();
        try {
            this.processor.recover(request);
            engine.getRequestRepository().updateRequest(request);
            auditor.log((LogEvent)new SecurityDataRecoveryProcessedEvent(auditSubjectID, "Success", requestID, keyId, null, approvers));
        }
        catch (EBaseException e) {
            auditor.log((LogEvent)new SecurityDataRecoveryProcessedEvent(auditSubjectID, "Failure", requestID, keyId, e.getMessage(), approvers));
            throw e;
        }
        return false;
    }
}

