/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.evaluators;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.SessionContext;
import com.netscape.certsrv.evaluators.AccessEvaluator;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.usrgrp.UGSubsystem;
import com.netscape.cmscore.usrgrp.User;
import java.util.Arrays;
import org.dogtagpki.server.authentication.AuthToken;
import org.mozilla.jss.netscape.security.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupAccessEvaluator
extends AccessEvaluator {
    public static Logger logger = LoggerFactory.getLogger(GroupAccessEvaluator.class);

    public GroupAccessEvaluator() {
        this.type = "group";
        this.description = "group membership evaluator";
    }

    @Override
    public void init() {
        logger.debug("GroupAccessEvaluator: init");
    }

    @Override
    public String[] getSupportedOperators() {
        String[] s = new String[]{"=", "!="};
        return s;
    }

    @Override
    public boolean evaluate(AuthToken authToken, String type, String op, String value) {
        UGSubsystem ug = this.engine.getUGSubsystem();
        if (type.equals(this.type)) {
            String uid = null;
            uid = authToken.getInString("userid");
            if (uid == null && (uid = authToken.getInString("uid")) == null) {
                logger.warn("GroupAccessEvaluator: " + CMS.getLogMessage("EVALUTOR_UID_NULL", new Object[0]));
                return false;
            }
            logger.debug("GroupAccessEvaluator: evaluate: uid=" + uid + " value=" + value);
            String[] groups = authToken.getInStringArray("groups");
            if (groups != null) {
                boolean matched = Arrays.asList(groups).contains(Utils.stripQuotes((String)value));
                if (op.equals("=")) {
                    return matched;
                }
                if (op.equals("!=")) {
                    return !matched;
                }
            } else {
                logger.debug("GroupAccessEvaluator: evaluate: no groups in authToken");
                User id = null;
                try {
                    id = ug.getUser(uid);
                }
                catch (EBaseException e) {
                    logger.warn("GroupAccessEvaluator: " + e.getMessage(), (Throwable)e);
                    return false;
                }
                if (op.equals("=")) {
                    return ug.isMemberOf(id, Utils.stripQuotes((String)value));
                }
                if (op.equals("!=")) {
                    return !ug.isMemberOf(id, Utils.stripQuotes((String)value));
                }
            }
        }
        return false;
    }

    @Override
    public boolean evaluate(String type, String op, String value) {
        UGSubsystem ug = this.engine.getUGSubsystem();
        SessionContext mSC = SessionContext.getContext();
        if (type.equals(this.type)) {
            User id = (User)mSC.get((Object)"user");
            if (id == null) {
                logger.warn("GroupAccessEvaluator: " + CMS.getLogMessage("EVALUTOR_UID_NULL", new Object[0]));
                return false;
            }
            boolean isMemberOfGroup = ug.isMemberOf(id, Utils.stripQuotes((String)value));
            return op.equals("=") ? isMemberOfGroup : !isMemberOfGroup;
        }
        return false;
    }
}

