/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.evaluators;

import com.netscape.certsrv.base.SessionContext;
import com.netscape.certsrv.evaluators.AccessEvaluator;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.usrgrp.User;
import org.dogtagpki.server.authentication.AuthToken;
import org.mozilla.jss.netscape.security.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserAccessEvaluator
extends AccessEvaluator {
    public static Logger logger = LoggerFactory.getLogger(UserAccessEvaluator.class);
    private static final String ANYBODY = "anybody";
    private static final String EVERYBODY = "everybody";

    public UserAccessEvaluator() {
        this.type = "user";
        this.description = "user equivalence evaluator";
    }

    @Override
    public void init() {
        logger.debug("UserAccessEvaluator: init");
    }

    @Override
    public String[] getSupportedOperators() {
        String[] s = new String[]{"=", "!="};
        return s;
    }

    @Override
    public boolean evaluate(AuthToken authToken, String type, String op, String value) {
        if (type.equals(this.type)) {
            String s = Utils.stripQuotes((String)value);
            if ((s.equals(ANYBODY) || s.equals(EVERYBODY)) && op.equals("=")) {
                return true;
            }
            if (authToken == null) {
                return false;
            }
            String uid = null;
            uid = authToken.getInString("uid");
            if (uid == null) {
                logger.warn("UserAccessEvaluator: " + CMS.getLogMessage("EVALUTOR_UID_IS_NULL", new Object[0]));
                return false;
            }
            if (op.equals("=")) {
                return s.equalsIgnoreCase(uid);
            }
            if (op.equals("!=")) {
                return !s.equalsIgnoreCase(uid);
            }
        }
        return false;
    }

    @Override
    public boolean evaluate(String type, String op, String value) {
        SessionContext mSC = SessionContext.getContext();
        if (type.equals(this.type)) {
            String s = Utils.stripQuotes((String)value);
            if (s.equals(ANYBODY) && op.equals("=")) {
                return true;
            }
            User id = (User)mSC.get((Object)"user");
            if (op.equals("=")) {
                return s.equalsIgnoreCase(id.getUserID());
            }
            if (op.equals("!=")) {
                return !s.equalsIgnoreCase(id.getUserID());
            }
        }
        return false;
    }
}

