/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.servlet.admin;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.IExtendedPluginInfo;
import com.netscape.certsrv.common.NameValuePairs;
import com.netscape.cms.servlet.admin.AdminServlet;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.apps.CMSEngine;
import com.netscape.cmscore.logging.Auditor;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dogtagpki.legacy.policy.IPolicyProcessor;
import org.dogtagpki.legacy.policy.IPolicyRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PolicyAdminServlet
extends AdminServlet {
    public static Logger logger = LoggerFactory.getLogger(PolicyAdminServlet.class);
    private static final long serialVersionUID = 8850646362111106656L;
    public static final String PROP_AUTHORITY = "authority";
    public static final String INFO = "PolicyAdminServlet";
    public static final String PW_PASSWORD_CACHE_ADD = "PASSWORD_CACHE_ADD";
    public static final String PROP_PREDICATE = "predicate";
    protected IPolicyProcessor mProcessor;
    public static String INVALID_POLICY_SCOPE = "Invalid policy administration scope";
    public static String INVALID_POLICY_IMPL_OP = "Invalid operation for policy implementation management";
    public static String NYI = "Not Yet Implemented";
    public static String INVALID_POLICY_IMPL_CONFIG = "Invalid policy implementation configuration";
    public static String INVALID_POLICY_INSTANCE_CONFIG = "Invalid policy instance configuration";
    public static String MISSING_POLICY_IMPL_ID = "Missing policy impl id in request";
    public static String MISSING_POLICY_IMPL_CLASS = "Missing policy impl class in request";
    public static String INVALID_POLICY_IMPL_ID = "Invalid policy impl id in request";
    public static String MISSING_POLICY_INST_ID = "Missing policy impl id in request";
    public static String INVALID_POLICY_INST_ID = "Invalid policy impl id in request";
    public static String COMMA = ",";
    public static String MISSING_POLICY_ORDERING = "Missing policy ordering";

    public String getServletInfo() {
        return INFO;
    }

    private void getExtendedPluginInfo(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException, EBaseException {
        String implName1;
        if (!this.readAuthorize(req, resp)) {
            return;
        }
        String id = req.getParameter("RS_ID");
        NameValuePairs params = null;
        int colon = id.indexOf(58);
        String implName = implName1 = id.substring(colon + 1);
        String instName = null;
        colon = implName1.indexOf(58);
        if (colon > -1) {
            implName = implName1.substring(0, colon);
            instName = implName1.substring(colon + 1);
            params = this.getExtendedPluginInfo(implName, instName);
        } else {
            params = this.getExtendedPluginInfo(implName);
        }
        this.sendResponse(SUCCESS, null, params, resp);
    }

    private NameValuePairs getExtendedPluginInfo(String implName) {
        IExtendedPluginInfo ext_info = null;
        IPolicyRule impl = null;
        IPolicyRule policy = this.mProcessor.getPolicyImpl(implName);
        impl = policy;
        if (impl != null && impl instanceof IExtendedPluginInfo) {
            ext_info = (IExtendedPluginInfo)impl;
        }
        NameValuePairs nvps = null;
        nvps = ext_info == null ? new NameValuePairs() : this.convertStringArrayToNVPairs(ext_info.getExtendedPluginInfo());
        return nvps;
    }

    public NameValuePairs getExtendedPluginInfo(String implName, String instName) {
        IExtendedPluginInfo ext_info = null;
        IPolicyRule impl = null;
        IPolicyRule policy = this.mProcessor.getPolicyInstance(instName);
        impl = policy;
        if (impl == null) {
            impl = this.mProcessor.getPolicyImpl(implName);
        }
        if (impl != null && impl instanceof IExtendedPluginInfo) {
            ext_info = (IExtendedPluginInfo)impl;
        }
        NameValuePairs nvps = null;
        nvps = ext_info == null ? new NameValuePairs() : this.convertStringArrayToNVPairs(ext_info.getExtendedPluginInfo());
        if (nvps != null) {
            this.addDefaultParams(impl, nvps);
        }
        return nvps;
    }

    private void addDefaultParams(Object ext_info, NameValuePairs nvps) {
        if (ext_info instanceof IPolicyRule) {
            if (nvps.get((Object)"enable") == null) {
                nvps.put((Object)"enable", (Object)"boolean;Enable this policy rule");
            }
            if (nvps.get((Object)PROP_PREDICATE) == null) {
                nvps.put((Object)PROP_PREDICATE, (Object)"string;Rules describing when this policy should run.");
            }
        }
    }

    @Override
    public void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.service(req, resp);
        super.authenticate(req);
        AUTHZ_RES_NAME = "certServer.policy.configuration";
        String scope = req.getParameter("OP_SCOPE");
        if (scope.equals("rules")) {
            this.processPolicyRuleMgmt(req, resp);
        } else if (scope.equals("impls")) {
            this.processPolicyImplMgmt(req, resp);
        } else if (scope.equals("extendedPluginInfo")) {
            try {
                this.getExtendedPluginInfo(req, resp);
            }
            catch (EBaseException e) {
                this.sendResponse(ERROR, e.toString(this.getLocale(req)), null, resp);
                return;
            }
        } else {
            this.sendResponse(ERROR, INVALID_POLICY_SCOPE, null, resp);
        }
    }

    private boolean readAuthorize(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        this.mOp = "read";
        this.mToken = super.authorize(req);
        if (this.mToken == null) {
            this.sendResponse(ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_ADMIN_SRVLT_AUTHZ_FAILED", new String[0]), null, resp);
            return false;
        }
        return true;
    }

    private boolean modifyAuthorize(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        this.mOp = "modify";
        this.mToken = super.authorize(req);
        if (this.mToken == null) {
            this.sendResponse(ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_ADMIN_SRVLT_AUTHZ_FAILED", new String[0]), null, resp);
            return false;
        }
        return true;
    }

    public void processPolicyImplMgmt(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String op = req.getParameter("OP_TYPE");
        if (op.equals("OP_SEARCH")) {
            if (!this.readAuthorize(req, resp)) {
                return;
            }
            this.listPolicyImpls(req, resp);
        } else if (op.equals("OP_DELETE")) {
            if (!this.modifyAuthorize(req, resp)) {
                return;
            }
            this.deletePolicyImpl(req, resp);
        } else if (op.equals("OP_READ")) {
            if (!this.readAuthorize(req, resp)) {
                return;
            }
            this.getPolicyImplConfig(req, resp);
        } else if (op.equals("OP_ADD")) {
            if (!this.modifyAuthorize(req, resp)) {
                return;
            }
            this.addPolicyImpl(req, resp);
        } else {
            this.sendResponse(ERROR, INVALID_POLICY_IMPL_OP, null, resp);
        }
    }

    public void processPolicyRuleMgmt(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String op = req.getParameter("OP_TYPE");
        if (op.equals("OP_SEARCH")) {
            if (!this.readAuthorize(req, resp)) {
                return;
            }
            this.listPolicyInstances(req, resp);
        } else if (op.equals("OP_DELETE")) {
            if (!this.modifyAuthorize(req, resp)) {
                return;
            }
            this.deletePolicyInstance(req, resp);
        } else if (op.equals("OP_READ")) {
            if (!this.readAuthorize(req, resp)) {
                return;
            }
            this.getPolicyInstanceConfig(req, resp);
        } else if (op.equals("OP_ADD")) {
            if (!this.modifyAuthorize(req, resp)) {
                return;
            }
            this.addPolicyInstance(req, resp);
        } else if (op.equals("OP_MODIFY")) {
            if (!this.modifyAuthorize(req, resp)) {
                return;
            }
            String id = req.getParameter("RS_ID");
            if (id.equalsIgnoreCase("RS_ID_ORDER")) {
                this.changePolicyInstanceOrdering(req, resp);
            } else {
                this.modifyPolicyInstance(req, resp);
            }
        } else {
            this.sendResponse(ERROR, INVALID_POLICY_IMPL_OP, null, resp);
        }
    }

    public void listPolicyImpls(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Enumeration<String> policyImplNames = this.mProcessor.getPolicyImplsInfo();
        Enumeration<IPolicyRule> policyImpls = this.mProcessor.getPolicyImpls();
        if (policyImplNames == null || policyImpls == null) {
            this.sendResponse(ERROR, INVALID_POLICY_IMPL_CONFIG, null, resp);
            return;
        }
        NameValuePairs nvp = new NameValuePairs();
        while (policyImplNames.hasMoreElements() && policyImpls.hasMoreElements()) {
            String id = policyImplNames.nextElement();
            IPolicyRule impl = policyImpls.nextElement();
            String className = impl.getClass().getName();
            String desc = impl.getDescription();
            nvp.put((Object)id, (Object)(className + "," + desc));
        }
        this.sendResponse(SUCCESS, null, nvp, resp);
    }

    public void listPolicyInstances(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Enumeration<String> instancesInfo = this.mProcessor.getPolicyInstancesInfo();
        if (instancesInfo == null) {
            this.sendResponse(ERROR, INVALID_POLICY_INSTANCE_CONFIG, null, resp);
            return;
        }
        NameValuePairs nvp = new NameValuePairs();
        while (instancesInfo.hasMoreElements()) {
            String info = instancesInfo.nextElement();
            int i = info.indexOf(";");
            nvp.put((Object)info.substring(0, i), (Object)info.substring(i + 1));
        }
        this.sendResponse(SUCCESS, null, nvp, resp);
    }

    public void deletePolicyImpl(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        CMSEngine engine = this.getCMSEngine();
        Auditor auditor = engine.getAuditor();
        String auditMessage = null;
        String auditSubjectID = this.auditSubjectID();
        try {
            String id = req.getParameter("RS_ID").trim();
            if (id == null) {
                auditMessage = CMS.getLogMessage("LOGGING_SIGNED_AUDIT_CONFIG_CERT_POLICY_3", auditSubjectID, "Failure", this.auditParams(req));
                auditor.log(auditMessage);
                this.sendResponse(ERROR, MISSING_POLICY_IMPL_ID, null, resp);
                return;
            }
            try {
                this.mProcessor.deletePolicyImpl(id);
                auditMessage = CMS.getLogMessage("LOGGING_SIGNED_AUDIT_CONFIG_CERT_POLICY_3", auditSubjectID, "Success", this.auditParams(req));
                auditor.log(auditMessage);
                this.sendResponse(SUCCESS, null, null, resp);
            }
            catch (Exception e) {
                auditMessage = CMS.getLogMessage("LOGGING_SIGNED_AUDIT_CONFIG_CERT_POLICY_3", auditSubjectID, "Failure", this.auditParams(req));
                auditor.log(auditMessage);
                this.sendResponse(ERROR, e.toString(), null, resp);
            }
        }
        catch (IOException eAudit1) {
            auditMessage = CMS.getLogMessage("LOGGING_SIGNED_AUDIT_CONFIG_CERT_POLICY_3", auditSubjectID, "Failure", this.auditParams(req));
            auditor.log(auditMessage);
            throw eAudit1;
        }
    }

    public void getPolicyImplConfig(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String id = req.getParameter("RS_ID");
        if (id == null) {
            this.sendResponse(ERROR, MISSING_POLICY_IMPL_ID, null, resp);
            return;
        }
        Vector<String> v = this.mProcessor.getPolicyImplConfig(id);
        if (v == null) {
            this.sendResponse(ERROR, INVALID_POLICY_IMPL_ID, null, resp);
            return;
        }
        NameValuePairs nvp = new NameValuePairs();
        Enumeration<String> e = v.elements();
        while (e.hasMoreElements()) {
            String nv = e.nextElement();
            int index = nv.indexOf("=");
            nvp.put((Object)nv.substring(0, index), (Object)nv.substring(index + 1));
        }
        this.sendResponse(SUCCESS, null, nvp, resp);
    }

    public void addPolicyImpl(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        CMSEngine engine = this.getCMSEngine();
        Auditor auditor = engine.getAuditor();
        String auditMessage = null;
        String auditSubjectID = this.auditSubjectID();
        try {
            String id = req.getParameter("RS_ID");
            if (id == null) {
                auditMessage = CMS.getLogMessage("LOGGING_SIGNED_AUDIT_CONFIG_CERT_POLICY_3", auditSubjectID, "Failure", this.auditParams(req));
                auditor.log(auditMessage);
                this.sendResponse(ERROR, MISSING_POLICY_IMPL_ID, null, resp);
                return;
            }
            String classPath = req.getParameter("class");
            if (classPath == null) {
                auditMessage = CMS.getLogMessage("LOGGING_SIGNED_AUDIT_CONFIG_CERT_POLICY_3", auditSubjectID, "Failure", this.auditParams(req));
                auditor.log(auditMessage);
                this.sendResponse(ERROR, MISSING_POLICY_IMPL_CLASS, null, resp);
                return;
            }
            try {
                this.mProcessor.addPolicyImpl(id, classPath);
                auditMessage = CMS.getLogMessage("LOGGING_SIGNED_AUDIT_CONFIG_CERT_POLICY_3", auditSubjectID, "Success", this.auditParams(req));
                auditor.log(auditMessage);
                this.sendResponse(SUCCESS, null, null, resp);
            }
            catch (Exception e) {
                auditMessage = CMS.getLogMessage("LOGGING_SIGNED_AUDIT_CONFIG_CERT_POLICY_3", auditSubjectID, "Failure", this.auditParams(req));
                auditor.log(auditMessage);
                this.sendResponse(ERROR, e.toString(), null, resp);
            }
        }
        catch (IOException eAudit1) {
            auditMessage = CMS.getLogMessage("LOGGING_SIGNED_AUDIT_CONFIG_CERT_POLICY_3", auditSubjectID, "Failure", this.auditParams(req));
            auditor.log(auditMessage);
            throw eAudit1;
        }
    }

    public void deletePolicyInstance(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        CMSEngine engine = this.getCMSEngine();
        Auditor auditor = engine.getAuditor();
        String auditMessage = null;
        String auditSubjectID = this.auditSubjectID();
        try {
            String id = req.getParameter("RS_ID").trim();
            if (id == null) {
                auditMessage = CMS.getLogMessage("LOGGING_SIGNED_AUDIT_CONFIG_CERT_POLICY_3", auditSubjectID, "Failure", this.auditParams(req));
                auditor.log(auditMessage);
                this.sendResponse(ERROR, MISSING_POLICY_INST_ID, null, resp);
                return;
            }
            try {
                this.mProcessor.deletePolicyInstance(id);
                auditMessage = CMS.getLogMessage("LOGGING_SIGNED_AUDIT_CONFIG_CERT_POLICY_3", auditSubjectID, "Success", this.auditParams(req));
                auditor.log(auditMessage);
                this.sendResponse(SUCCESS, null, null, resp);
            }
            catch (Exception e) {
                auditMessage = CMS.getLogMessage("LOGGING_SIGNED_AUDIT_CONFIG_CERT_POLICY_3", auditSubjectID, "Failure", this.auditParams(req));
                auditor.log(auditMessage);
                this.sendResponse(ERROR, e.toString(), null, resp);
            }
        }
        catch (IOException eAudit1) {
            auditMessage = CMS.getLogMessage("LOGGING_SIGNED_AUDIT_CONFIG_CERT_POLICY_3", auditSubjectID, "Failure", this.auditParams(req));
            auditor.log(auditMessage);
            throw eAudit1;
        }
    }

    public void getPolicyInstanceConfig(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String id = req.getParameter("RS_ID").trim();
        if (id == null) {
            this.sendResponse(ERROR, MISSING_POLICY_INST_ID, null, resp);
            return;
        }
        Vector<String> v = this.mProcessor.getPolicyInstanceConfig(id);
        if (v == null) {
            this.sendResponse(ERROR, INVALID_POLICY_INST_ID, null, resp);
            return;
        }
        NameValuePairs nvp = new NameValuePairs();
        Enumeration<String> e = v.elements();
        while (e.hasMoreElements()) {
            String nv = e.nextElement();
            int index = nv.indexOf("=");
            String name = nv.substring(0, index);
            String value = nv.substring(index + 1);
            if (value == null) {
                value = "";
            }
            nvp.put((Object)name, (Object)value);
        }
        this.sendResponse(SUCCESS, null, nvp, resp);
    }

    public void putUserPWPair(String combo) {
        int semicolon = combo.indexOf(";");
        String user = combo.substring(0, semicolon);
        String pw = combo.substring(semicolon + 1);
        CMSEngine engine = this.getCMSEngine();
        engine.putPasswordCache(user, pw);
    }

    public void addPolicyInstance(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        CMSEngine engine = this.getCMSEngine();
        Auditor auditor = engine.getAuditor();
        String auditMessage = null;
        String auditSubjectID = this.auditSubjectID();
        try {
            String id = req.getParameter("RS_ID");
            if (id == null) {
                auditMessage = CMS.getLogMessage("LOGGING_SIGNED_AUDIT_CONFIG_CERT_POLICY_3", auditSubjectID, "Failure", this.auditParams(req));
                auditor.log(auditMessage);
                this.sendResponse(ERROR, MISSING_POLICY_INST_ID, null, resp);
                return;
            }
            String implName = req.getParameter("implName");
            if (implName == null) {
                auditMessage = CMS.getLogMessage("LOGGING_SIGNED_AUDIT_CONFIG_CERT_POLICY_3", auditSubjectID, "Failure", this.auditParams(req));
                auditor.log(auditMessage);
                this.sendResponse(ERROR, MISSING_POLICY_IMPL_ID, null, resp);
                return;
            }
            Hashtable<String, String> ht = new Hashtable<String, String>();
            String val = req.getParameter("enable").trim();
            if (val == null) {
                val = "true";
            }
            ht.put("enable", val);
            val = req.getParameter(PROP_PREDICATE);
            if (val != null) {
                ht.put(PROP_PREDICATE, val);
            }
            ht.put("implName", implName);
            Vector<String> v = this.mProcessor.getPolicyImplConfig(implName);
            if (v == null) {
                auditMessage = CMS.getLogMessage("LOGGING_SIGNED_AUDIT_CONFIG_CERT_POLICY_3", auditSubjectID, "Failure", this.auditParams(req));
                auditor.log(auditMessage);
                this.sendResponse(ERROR, INVALID_POLICY_IMPL_ID, null, resp);
                return;
            }
            Enumeration<String> e = v.elements();
            while (e.hasMoreElements()) {
                int index;
                String nv = e.nextElement();
                String key = nv.substring(0, index = nv.indexOf("="));
                val = req.getParameter(key).trim();
                if (val == null) continue;
                ht.put(key, val);
            }
            String pwadd = req.getParameter(PW_PASSWORD_CACHE_ADD);
            if (pwadd != null) {
                this.putUserPWPair(pwadd);
            }
            try {
                this.mProcessor.addPolicyInstance(id, ht);
                auditMessage = CMS.getLogMessage("LOGGING_SIGNED_AUDIT_CONFIG_CERT_POLICY_3", auditSubjectID, "Success", this.auditParams(req));
                auditor.log(auditMessage);
                this.sendResponse(SUCCESS, null, null, resp);
            }
            catch (Exception e2) {
                auditMessage = CMS.getLogMessage("LOGGING_SIGNED_AUDIT_CONFIG_CERT_POLICY_3", auditSubjectID, "Failure", this.auditParams(req));
                auditor.log(auditMessage);
                this.sendResponse(ERROR, e2.toString(), null, resp);
            }
        }
        catch (IOException eAudit1) {
            auditMessage = CMS.getLogMessage("LOGGING_SIGNED_AUDIT_CONFIG_CERT_POLICY_3", auditSubjectID, "Failure", this.auditParams(req));
            auditor.log(auditMessage);
            throw eAudit1;
        }
    }

    public void changePolicyInstanceOrdering(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        CMSEngine engine = this.getCMSEngine();
        Auditor auditor = engine.getAuditor();
        String auditMessage = null;
        String auditSubjectID = this.auditSubjectID();
        try {
            String policyOrder = req.getParameter("order");
            if (policyOrder == null) {
                auditMessage = CMS.getLogMessage("LOGGING_SIGNED_AUDIT_CONFIG_CERT_POLICY_3", auditSubjectID, "Failure", this.auditParams(req));
                auditor.log(auditMessage);
                this.sendResponse(ERROR, MISSING_POLICY_ORDERING, null, resp);
                return;
            }
            try {
                this.mProcessor.changePolicyInstanceOrdering(policyOrder);
                auditMessage = CMS.getLogMessage("LOGGING_SIGNED_AUDIT_CONFIG_CERT_POLICY_3", auditSubjectID, "Success", this.auditParams(req));
                auditor.log(auditMessage);
                this.sendResponse(SUCCESS, null, null, resp);
            }
            catch (Exception e) {
                auditMessage = CMS.getLogMessage("LOGGING_SIGNED_AUDIT_CONFIG_CERT_POLICY_3", auditSubjectID, "Failure", this.auditParams(req));
                auditor.log(auditMessage);
                this.sendResponse(ERROR, e.toString(), null, resp);
            }
        }
        catch (IOException eAudit1) {
            auditMessage = CMS.getLogMessage("LOGGING_SIGNED_AUDIT_CONFIG_CERT_POLICY_3", auditSubjectID, "Failure", this.auditParams(req));
            auditor.log(auditMessage);
            throw eAudit1;
        }
    }

    public void modifyPolicyInstance(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        CMSEngine engine = this.getCMSEngine();
        Auditor auditor = engine.getAuditor();
        String auditMessage = null;
        String auditSubjectID = this.auditSubjectID();
        try {
            String id = req.getParameter("RS_ID");
            if (id == null) {
                auditMessage = CMS.getLogMessage("LOGGING_SIGNED_AUDIT_CONFIG_CERT_POLICY_3", auditSubjectID, "Failure", this.auditParams(req));
                auditor.log(auditMessage);
                this.sendResponse(ERROR, MISSING_POLICY_INST_ID, null, resp);
                return;
            }
            String implName = req.getParameter("implName").trim();
            if (implName == null) {
                auditMessage = CMS.getLogMessage("LOGGING_SIGNED_AUDIT_CONFIG_CERT_POLICY_3", auditSubjectID, "Failure", this.auditParams(req));
                auditor.log(auditMessage);
                this.sendResponse(ERROR, MISSING_POLICY_IMPL_ID, null, resp);
                return;
            }
            Hashtable<String, String> ht = new Hashtable<String, String>();
            String val = req.getParameter("enable").trim();
            if (val == null) {
                val = "true";
            }
            ht.put("enable", val);
            val = req.getParameter(PROP_PREDICATE);
            if (val != null) {
                ht.put(PROP_PREDICATE, val);
            }
            ht.put("implName", implName);
            Vector<String> v = this.mProcessor.getPolicyImplConfig(implName);
            if (v == null) {
                auditMessage = CMS.getLogMessage("LOGGING_SIGNED_AUDIT_CONFIG_CERT_POLICY_3", auditSubjectID, "Failure", this.auditParams(req));
                auditor.log(auditMessage);
                this.sendResponse(ERROR, INVALID_POLICY_IMPL_ID, null, resp);
                return;
            }
            Enumeration n = req.getParameterNames();
            while (n.hasMoreElements()) {
                String p = (String)n.nextElement();
                String l = req.getParameter(p);
                if (l == null) continue;
                ht.put(p, l);
            }
            try {
                this.mProcessor.modifyPolicyInstance(id, ht);
                auditMessage = CMS.getLogMessage("LOGGING_SIGNED_AUDIT_CONFIG_CERT_POLICY_3", auditSubjectID, "Success", this.auditParams(req));
                auditor.log(auditMessage);
                this.sendResponse(SUCCESS, null, null, resp);
            }
            catch (Exception e) {
                auditMessage = CMS.getLogMessage("LOGGING_SIGNED_AUDIT_CONFIG_CERT_POLICY_3", auditSubjectID, "Failure", this.auditParams(req));
                auditor.log(auditMessage);
                this.sendResponse(ERROR, e.toString(), null, resp);
            }
        }
        catch (IOException eAudit1) {
            auditMessage = CMS.getLogMessage("LOGGING_SIGNED_AUDIT_CONFIG_CERT_POLICY_3", auditSubjectID, "Failure", this.auditParams(req));
            auditor.log(auditMessage);
            throw eAudit1;
        }
    }
}

