/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmscore.ldapconn;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.cmscore.ldapconn.LDAPAuthenticationConfig;
import com.netscape.cmsutil.password.PasswordStore;
import java.util.Hashtable;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapAuthInfo {
    public static final Logger logger = LoggerFactory.getLogger(LdapAuthInfo.class);
    public static final String PROP_LDAPAUTHTYPE = "authtype";
    public static final String PROP_CLIENTCERTNICKNAME = "clientCertNickname";
    public static final String PROP_BINDDN = "bindDN";
    public static final String PROP_BINDPW = "bindPassword";
    public static final String PROP_BINDPW_PROMPT = "bindPWPrompt";
    public static final String PROP_BINDDN_DEFAULT = "cn=Directory Manager";
    public static final String LDAP_BASICAUTH_STR = "BasicAuth";
    public static final String LDAP_SSLCLIENTAUTH_STR = "SslClientAuth";
    public static final int LDAP_AUTHTYPE_NONE = 0;
    public static final int LDAP_AUTHTYPE_BASICAUTH = 1;
    public static final int LDAP_AUTHTYPE_SSLCLIENTAUTH = 2;
    LDAPAuthenticationConfig config;
    String host;
    int port;
    boolean secure;
    protected int mType = -1;
    String bindDN;
    String nickname;
    private boolean mInited = false;
    PasswordStore passwordStore;
    private static Hashtable<String, String> passwords = new Hashtable();
    private static LDAPConnection conn = new LDAPConnection();

    public String getPasswordFromStore(String prompt) {
        String pwd = null;
        logger.debug("LdapAuthInfo: getPasswordFromStore: try to get it from password store");
        logger.debug("LdapAuthInfo: getPasswordFromStore: about to get from passwored store: " + prompt);
        if (this.passwordStore != null) {
            logger.debug("LdapAuthInfo: getPasswordFromStore: password store available");
            pwd = this.passwordStore.getPassword(prompt, 0);
            if (pwd == null) {
                logger.debug("LdapAuthInfo: getPasswordFromStore: password for " + prompt + " not found, trying internaldb");
                pwd = this.passwordStore.getPassword("internaldb", 0);
            } else {
                logger.debug("LdapAuthInfo: getPasswordFromStore: password found for prompt in password store");
            }
        } else {
            logger.debug("LdapAuthInfo: getPasswordFromStore: password store not available: pwdStore is null");
        }
        return pwd;
    }

    public void init(LDAPAuthenticationConfig config) throws EBaseException {
        this.init(config, null, 0, true);
    }

    public void init(LDAPAuthenticationConfig config, String host, int port, boolean secure) throws EBaseException {
        logger.debug("LdapAuthInfo: init()");
        if (this.mInited) {
            logger.debug("LdapAuthInfo: already initialized");
            return;
        }
        logger.debug("LdapAuthInfo: init begins");
        this.config = config;
        this.host = host;
        this.port = port;
        this.secure = secure;
        String authTypeStr = config.getAuthType();
        if (authTypeStr.equals(LDAP_BASICAUTH_STR)) {
            this.mType = 1;
        } else if (authTypeStr.equals(LDAP_SSLCLIENTAUTH_STR)) {
            this.mType = 2;
        } else {
            throw new IllegalArgumentException("Unknown Ldap authentication type " + authTypeStr);
        }
        this.mInited = true;
        logger.debug("LdapAuthInfo: init ends");
    }

    public String getBindDN() throws EBaseException {
        if (this.bindDN == null) {
            this.bindDN = this.config.getBindDN();
        }
        return this.bindDN;
    }

    public String getBindPassword() throws EBaseException {
        boolean inMem = false;
        String bindPassword = this.config.getBindPassword();
        String prompt = this.config.getBindPasswordPrompt();
        if (prompt == null) {
            prompt = "LDAP Authentication";
            logger.debug("LdapAuthInfo: init: prompt is null, change to " + prompt);
        } else {
            logger.debug("LdapAuthInfo: init: prompt is " + prompt);
        }
        if (bindPassword == null) {
            logger.debug("LdapAuthInfo: init: try getting from memory cache");
            bindPassword = passwords.get(prompt);
            if (bindPassword != null) {
                inMem = true;
                logger.debug("LdapAuthInfo: init: got password from memory");
            } else {
                logger.debug("LdapAuthInfo: init: password not in memory");
            }
        } else {
            logger.debug("LdapAuthInfo: init: found password from config");
        }
        if (bindPassword == null) {
            bindPassword = this.getPasswordFromStore(prompt);
        } else {
            logger.debug("LdapAuthInfo: init: password found for prompt.");
        }
        if (bindPassword != null && !bindPassword.equals("") && (this.host == null || LdapAuthInfo.authInfoOK(this.host, this.port, this.secure, this.bindDN, bindPassword))) {
            logger.debug("LdapAuthInfo: password ok: store in memory cache");
            passwords.put(prompt, bindPassword);
        } else if (bindPassword == null) {
            logger.debug("LdapAuthInfo: password not found");
        } else {
            logger.debug("LdapAuthInfo: password does not work");
            if (inMem && LdapAuthInfo.authInfoOK(this.host, this.port, this.secure, this.bindDN, bindPassword = this.getPasswordFromStore(prompt))) {
                logger.debug("LdapAuthInfo: password ok: store in memory cache");
                passwords.put(prompt, bindPassword);
            }
        }
        return bindPassword;
    }

    public String getClientCertNickname() throws EBaseException {
        if (this.nickname == null) {
            this.nickname = this.config.getClientCertNickname();
        }
        return this.nickname;
    }

    public void reset() {
        try {
            conn.disconnect();
        }
        catch (LDAPException lDAPException) {
            // empty catch block
        }
    }

    private static boolean authInfoOK(String host, int port, boolean secure, String dn, String pw) {
        if (secure) {
            return true;
        }
        boolean connected = false;
        boolean authenticated = false;
        try {
            conn.connect(host, port);
            connected = true;
            conn.authenticate(dn, pw);
            authenticated = true;
        }
        catch (LDAPException lDAPException) {
            // empty catch block
        }
        return !connected || authenticated;
    }

    public int getAuthType() {
        return this.mType;
    }

    public PasswordStore getPasswordStore() {
        return this.passwordStore;
    }

    public void setPasswordStore(PasswordStore passwordStore) {
        this.passwordStore = passwordStore;
    }

    public void addPassword(String prompt, String pw) {
        passwords.put(prompt, pw);
    }

    public void removePassword(String prompt) {
        passwords.remove(prompt);
    }
}

