/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.server.rest;

import com.netscape.certsrv.base.BadRequestException;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.PKIException;
import com.netscape.certsrv.base.ResourceNotFoundException;
import com.netscape.certsrv.logging.AuditConfig;
import com.netscape.certsrv.logging.AuditFile;
import com.netscape.certsrv.logging.AuditFileCollection;
import com.netscape.certsrv.logging.AuditResource;
import com.netscape.certsrv.logging.event.ConfigSignedAuditEvent;
import com.netscape.cms.servlet.base.SubsystemService;
import com.netscape.cmscore.apps.CMSEngine;
import com.netscape.cmscore.apps.EngineConfig;
import com.netscape.cmscore.logging.Auditor;
import com.netscape.cmscore.logging.LogSubsystem;
import com.netscape.cmscore.logging.LoggerConfig;
import com.netscape.cmscore.logging.LoggersConfig;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditService
extends SubsystemService
implements AuditResource {
    public static Logger logger = LoggerFactory.getLogger(AuditService.class);

    public AuditService() {
        logger.debug("AuditService.<init>()");
    }

    public AuditConfig createAuditConfig() throws UnsupportedEncodingException, EBaseException {
        return this.createAuditConfig(null);
    }

    public AuditConfig createAuditConfig(Map<String, String> auditParams) throws UnsupportedEncodingException, EBaseException {
        CMSEngine engine = this.getCMSEngine();
        EngineConfig cs = engine.getConfig();
        LoggersConfig loggersConfig = cs.getLoggingConfig().getLoggersConfig();
        LoggerConfig loggerConfig = loggersConfig.getLoggerConfig("SignedAudit");
        AuditConfig auditConfig = new AuditConfig();
        String val = null;
        Boolean boolval = false;
        val = loggerConfig.getBoolean("enable", false) ? "Enabled" : "Disabled";
        auditConfig.setStatus(val);
        if (auditParams != null) {
            auditParams.put("enable", val);
        }
        boolval = loggerConfig.getBoolean("logSigning", false);
        if (auditParams != null) {
            auditParams.put("logSigning", boolval != false ? "true" : "false");
        }
        auditConfig.setSigned(boolval);
        Integer integerval = loggerConfig.getInteger("flushInterval", 5);
        auditConfig.setInterval(integerval);
        if (auditParams != null) {
            auditParams.put("flushInterval", integerval.toString());
        }
        integerval = loggerConfig.getInteger("bufferSize", 512);
        auditConfig.setBufferSize(integerval);
        if (auditParams != null) {
            auditParams.put("bufferSize", integerval.toString());
        }
        TreeMap<String, String> eventConfigs = new TreeMap<String, String>();
        LogSubsystem logSubsystem = engine.getLogSubsystem();
        for (String name : logSubsystem.getAuditEvents()) {
            eventConfigs.put(name, "disabled");
        }
        val = loggerConfig.getString("events", "");
        if (auditParams != null) {
            auditParams.put("events", val);
        }
        for (String event : StringUtils.split((String)val, (String)", ")) {
            eventConfigs.put(event.trim(), "enabled");
        }
        val = loggerConfig.getString("mandatory.events", "");
        if (auditParams != null) {
            auditParams.put("mandatory.events", val);
        }
        for (String event : StringUtils.split((String)val, (String)", ")) {
            eventConfigs.put(event.trim(), "mandatory");
        }
        auditConfig.setEventConfigs(eventConfigs);
        return auditConfig;
    }

    public Response getAuditConfig() {
        logger.debug("AuditService.getAuditConfig()");
        try {
            return this.createOKResponse(this.createAuditConfig());
        }
        catch (PKIException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PKIException(e.getMessage());
        }
    }

    public Response updateAuditConfig(AuditConfig auditConfig) {
        HashMap<String, String> auditModParams = new HashMap<String, String>();
        if (auditConfig == null) {
            BadRequestException e = new BadRequestException("Missing audit configuration");
            auditModParams.put("Info", e.toString());
            this.auditTPSConfigSignedAudit("Failure", auditModParams);
            throw e;
        }
        logger.info("AuditService: Updating audit configuration:");
        CMSEngine engine = this.getCMSEngine();
        EngineConfig cs = engine.getConfig();
        LoggersConfig loggersConfig = cs.getLoggingConfig().getLoggersConfig();
        LoggerConfig loggerConfig = loggersConfig.getLoggerConfig("SignedAudit");
        try {
            Map eventConfigs;
            AuditConfig currentAuditConfig = this.createAuditConfig();
            Map currentEventConfigs = currentAuditConfig.getEventConfigs();
            if (auditConfig.getSigned() != null) {
                logger.info("AuditService: - log signing: " + auditConfig.getSigned());
                loggerConfig.putBoolean("logSigning", auditConfig.getSigned());
            }
            if (auditConfig.getInterval() != null) {
                logger.info("AuditService: - flush interval: " + auditConfig.getInterval());
                loggerConfig.putInteger("flushInterval", auditConfig.getInterval());
            }
            if (auditConfig.getBufferSize() != null) {
                logger.info("AuditService: - buffer size: " + auditConfig.getBufferSize());
                loggerConfig.putInteger("bufferSize", auditConfig.getBufferSize());
            }
            if ((eventConfigs = auditConfig.getEventConfigs()) != null) {
                logger.info("AuditService: Updating audit events:");
                TreeSet<String> selected = new TreeSet<String>();
                for (Map.Entry entry : eventConfigs.entrySet()) {
                    String name = (String)entry.getKey();
                    String value = (String)entry.getValue();
                    logger.info("AuditService: - " + name + ": " + value);
                    String currentValue = (String)currentEventConfigs.get(name);
                    if (currentValue == null) {
                        PKIException e = new PKIException("Unable to add event: " + name);
                        auditModParams.put("Info", e.toString());
                        this.auditTPSConfigSignedAudit("Failure", auditModParams);
                        throw e;
                    }
                    if ("mandatory".equals(value)) {
                        if ("mandatory".equals(currentValue)) continue;
                        PKIException e = new PKIException("Unable to add mandatory event: " + name);
                        auditModParams.put("Info", e.toString());
                        this.auditTPSConfigSignedAudit("Failure", auditModParams);
                        throw e;
                    }
                    if ("mandatory".equals(currentValue)) {
                        PKIException e = new PKIException("Unable to remove mandatory event: " + name);
                        auditModParams.put("Info", e.toString());
                        this.auditTPSConfigSignedAudit("Failure", auditModParams);
                        throw e;
                    }
                    if ("enabled".equals(value)) {
                        selected.add(name);
                        continue;
                    }
                    if ("disabled".equals(value)) continue;
                    PKIException e = new PKIException("Invalid event configuration: " + name + "=" + value);
                    auditModParams.put("Info", e.toString());
                    this.auditTPSConfigSignedAudit("Failure", auditModParams);
                    throw e;
                }
                loggerConfig.putString("events", StringUtils.join(selected, (String)","));
            }
            for (String name : currentEventConfigs.keySet()) {
                if (eventConfigs.containsKey(name)) continue;
                PKIException e = new PKIException("Unable to remove event: " + name);
                auditModParams.put("Info", e.toString());
                this.auditTPSConfigSignedAudit("Failure", auditModParams);
                throw e;
            }
            cs.commit(true);
            auditConfig = this.createAuditConfig(auditModParams);
            this.auditTPSConfigSignedAudit("Success", auditModParams);
            return this.createOKResponse(auditConfig);
        }
        catch (PKIException e) {
            logger.error("Unable to update audit configuration: " + e.getMessage(), (Throwable)e);
            auditModParams.put("Info", e.toString());
            this.auditTPSConfigSignedAudit("Failure", auditModParams);
            throw e;
        }
        catch (Exception e) {
            logger.error("Unable to update audit configuration: " + e.getMessage(), (Throwable)e);
            auditModParams.put("Info", e.toString());
            this.auditTPSConfigSignedAudit("Failure", auditModParams);
            throw new PKIException(e.getMessage());
        }
    }

    public Response changeAuditStatus(String action) {
        HashMap<String, String> auditModParams = new HashMap<String, String>();
        logger.debug("AuditService.changeAuditStatus()");
        CMSEngine engine = this.getCMSEngine();
        EngineConfig cs = engine.getConfig();
        LoggersConfig loggersConfig = cs.getLoggingConfig().getLoggersConfig();
        LoggerConfig loggerConfig = loggersConfig.getLoggerConfig("SignedAudit");
        try {
            auditModParams.put("Action", action);
            if ("enable".equals(action)) {
                loggerConfig.putBoolean("enable", true);
            } else if ("disable".equals(action)) {
                loggerConfig.putBoolean("enable", false);
            } else {
                BadRequestException e = new BadRequestException("Invalid action " + action);
                auditModParams.put("Info", e.toString());
                this.auditTPSConfigSignedAudit("Failure", auditModParams);
                throw e;
            }
            cs.commit(true);
            AuditConfig auditConfig = this.createAuditConfig();
            this.auditTPSConfigSignedAudit("Success", auditModParams);
            return this.createOKResponse(auditConfig);
        }
        catch (PKIException e) {
            auditModParams.put("Info", e.toString());
            this.auditTPSConfigSignedAudit("Failure", auditModParams);
            e.printStackTrace();
            throw e;
        }
        catch (Exception e) {
            auditModParams.put("Info", e.toString());
            this.auditTPSConfigSignedAudit("Failure", auditModParams);
            e.printStackTrace();
            e.printStackTrace();
            throw new PKIException(e.getMessage());
        }
    }

    public File getCurrentLogFile() {
        CMSEngine engine = this.getCMSEngine();
        EngineConfig cs = engine.getConfig();
        LoggersConfig loggersConfig = cs.getLoggingConfig().getLoggersConfig();
        LoggerConfig loggerConfig = loggersConfig.getLoggerConfig("SignedAudit");
        String filename = loggerConfig.get("fileName");
        return new File(filename);
    }

    public File getLogDirectory() {
        File file = this.getCurrentLogFile();
        return file.getParentFile();
    }

    public List<File> getLogFiles() {
        ArrayList<String> filenames = new ArrayList<String>();
        File currentFile = this.getCurrentLogFile();
        String currentFilename = currentFile.getName();
        File logDir = currentFile.getParentFile();
        for (String filename : logDir.list()) {
            if (filename.equals(currentFilename)) continue;
            filenames.add(filename);
        }
        Collections.sort(filenames);
        filenames.add(currentFilename);
        ArrayList<File> files = new ArrayList<File>();
        for (String filename : filenames) {
            files.add(new File(logDir, filename));
        }
        return files;
    }

    public Response findAuditFiles() {
        AuditFileCollection response = new AuditFileCollection();
        List<File> files = this.getLogFiles();
        logger.debug("Audit files:");
        for (File file : files) {
            String name = file.getName();
            logger.debug("- " + name);
            AuditFile auditFile = new AuditFile();
            auditFile.setName(name);
            auditFile.setSize(Long.valueOf(file.length()));
            response.addEntry((Object)auditFile);
        }
        response.setTotal(files.size());
        return this.createOKResponse(response);
    }

    public Response getAuditFile(String filename) {
        if (!new File(filename).getName().equals(filename)) {
            logger.error("Invalid file name: " + filename);
            throw new BadRequestException("Invalid file name: " + filename);
        }
        File logDir = this.getLogDirectory();
        final File file = new File(logDir, filename);
        if (!file.exists()) {
            throw new ResourceNotFoundException("File not found: " + filename);
        }
        StreamingOutput so = new StreamingOutput(){

            public void write(OutputStream out) throws IOException, WebApplicationException {
                try (FileInputStream is = new FileInputStream(file);){
                    IOUtils.copy((InputStream)is, (OutputStream)out);
                }
            }
        };
        return this.createOKResponse(so);
    }

    public void auditTPSConfigSignedAudit(String status, Map<String, String> params) {
        CMSEngine engine = this.getCMSEngine();
        Auditor auditor = engine.getAuditor();
        auditor.log(new ConfigSignedAuditEvent(this.servletRequest.getUserPrincipal().getName(), status, auditor.getParamString(params)));
    }
}

