/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmstools;

import com.netscape.cmsutil.crypto.CryptoUtil;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SignatureException;
import java.util.Date;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.InitializationValues;
import org.mozilla.jss.asn1.ANY;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.INTEGER;
import org.mozilla.jss.asn1.OBJECT_IDENTIFIER;
import org.mozilla.jss.asn1.OCTET_STRING;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.SET;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.DigestAlgorithm;
import org.mozilla.jss.crypto.ObjectNotFoundException;
import org.mozilla.jss.crypto.PrivateKey;
import org.mozilla.jss.crypto.SignatureAlgorithm;
import org.mozilla.jss.crypto.X509Certificate;
import org.mozilla.jss.netscape.security.pkcs.PKCS10;
import org.mozilla.jss.netscape.security.util.Utils;
import org.mozilla.jss.netscape.security.x509.X500Name;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.mozilla.jss.pkcs10.CertificationRequest;
import org.mozilla.jss.pkix.cmc.PKIData;
import org.mozilla.jss.pkix.cmc.TaggedAttribute;
import org.mozilla.jss.pkix.cmc.TaggedCertificationRequest;
import org.mozilla.jss.pkix.cmc.TaggedRequest;
import org.mozilla.jss.pkix.cms.ContentInfo;
import org.mozilla.jss.pkix.cms.EncapsulatedContentInfo;
import org.mozilla.jss.pkix.cms.IssuerAndSerialNumber;
import org.mozilla.jss.pkix.cms.SignedData;
import org.mozilla.jss.pkix.cms.SignerIdentifier;
import org.mozilla.jss.pkix.cms.SignerInfo;
import org.mozilla.jss.pkix.primitive.AlgorithmIdentifier;
import org.mozilla.jss.pkix.primitive.Name;
import org.mozilla.jss.util.Password;
import org.mozilla.jss.util.PasswordCallback;

public class CMCEnroll {
    public static final String PR_REQUEST_CMC = "CMC";
    public static final String PR_REQUEST_PKCS10 = "PKCS10";
    public static final int ARGC = 4;
    public static final String HEADER = "-----BEGIN";
    public static final String TRAILER = "-----END";

    void cleanArgs(String[] s) {
    }

    public static X509Certificate getCertificate(String tokenname, String nickname) throws Exception {
        CryptoManager manager = CryptoManager.getInstance();
        CryptoToken token = CryptoUtil.getKeyStorageToken((String)tokenname);
        StringBuffer certname = new StringBuffer();
        if (!token.equals((Object)manager.getInternalKeyStorageToken())) {
            certname.append(tokenname);
            certname.append(":");
        }
        certname.append(nickname);
        try {
            return manager.findCertByNickname(certname.toString());
        }
        catch (ObjectNotFoundException e) {
            throw new IOException("Signing Certificate not found");
        }
    }

    public static PrivateKey getPrivateKey(String tokenname, String nickname) throws Exception {
        X509Certificate cert = CMCEnroll.getCertificate(tokenname, nickname);
        return CryptoManager.getInstance().findPrivKeyByCert(cert);
    }

    static String getCMCBlob(X509Certificate signerCert, CryptoManager manager, String nValue, String rValue) {
        String asciiBASE64Blob = rValue;
        String tokenname = "internal";
        try {
            byte[] transId;
            byte[] dig;
            PrivateKey privKey = null;
            PKCS10 pkcs = null;
            SignerIdentifier si = null;
            ContentInfo fullEnrollmentReq = null;
            try {
                byte[] decodedBytes = Utils.base64decode((String)asciiBASE64Blob);
                pkcs = new PKCS10(decodedBytes);
            }
            catch (IOException e) {
                throw new IOException("Internal Error - " + e.toString());
            }
            catch (SignatureException e) {
                throw new IOException("Internal Error - " + e.toString());
            }
            catch (NoSuchAlgorithmException e) {
                throw new IOException("Internal Error - " + e.toString());
            }
            BigInteger serialno = signerCert.getSerialNumber();
            byte[] certB = signerCert.getEncoded();
            X509CertImpl impl = new X509CertImpl(certB);
            X500Name issuerName = impl.getIssuerName();
            byte[] issuerByte = issuerName.getEncoded();
            ByteArrayInputStream istream = new ByteArrayInputStream(issuerByte);
            Name issuer = (Name)Name.getTemplate().decode((InputStream)istream);
            IssuerAndSerialNumber ias = new IssuerAndSerialNumber(issuer, new INTEGER(serialno.toString()));
            si = new SignerIdentifier(SignerIdentifier.ISSUER_AND_SERIALNUMBER, ias, null);
            privKey = CMCEnroll.getPrivateKey(tokenname, nValue);
            int bpid = 1;
            ByteArrayInputStream crInputStream = new ByteArrayInputStream(pkcs.toByteArray());
            CertificationRequest cr = (CertificationRequest)CertificationRequest.getTemplate().decode((InputStream)crInputStream);
            TaggedCertificationRequest tcr = new TaggedCertificationRequest(new INTEGER((long)bpid++), cr);
            TaggedRequest trq = new TaggedRequest(TaggedRequest.PKCS10, tcr, null);
            SEQUENCE reqSequence = new SEQUENCE();
            reqSequence.addElement((ASN1Value)trq);
            SEQUENCE controlSeq = new SEQUENCE();
            Date date = new Date();
            String salt = "lala123" + date.toString();
            try {
                MessageDigest SHA1Digest = MessageDigest.getInstance("SHA1");
                dig = SHA1Digest.digest(salt.getBytes());
            }
            catch (NoSuchAlgorithmException ex) {
                dig = salt.getBytes();
            }
            String sn = Utils.base64encode((byte[])dig, (boolean)true);
            TaggedAttribute senderNonce = new TaggedAttribute(new INTEGER((long)bpid++), OBJECT_IDENTIFIER.id_cmc_senderNonce, (ASN1Value)new OCTET_STRING(sn.getBytes()));
            controlSeq.addElement((ASN1Value)senderNonce);
            try {
                MessageDigest MD5Digest = MessageDigest.getInstance("MD5");
                transId = MD5Digest.digest(pkcs.getSubjectPublicKeyInfo().getKey());
            }
            catch (Exception ex) {
                transId = salt.getBytes();
            }
            TaggedAttribute transactionId = new TaggedAttribute(new INTEGER((long)bpid++), OBJECT_IDENTIFIER.id_cmc_transactionId, (ASN1Value)new INTEGER(1, transId));
            controlSeq.addElement((ASN1Value)transactionId);
            PKIData pkidata = new PKIData(controlSeq, reqSequence, new SEQUENCE(), new SEQUENCE());
            EncapsulatedContentInfo ci = new EncapsulatedContentInfo(OBJECT_IDENTIFIER.id_cct_PKIData, (ASN1Value)pkidata);
            DigestAlgorithm digestAlg = null;
            SignatureAlgorithm signAlg = SignatureAlgorithm.RSASignatureWithSHA1Digest;
            PrivateKey.Type signingKeyType = ((org.mozilla.jss.crypto.PrivateKey)privKey).getType();
            if (signingKeyType.equals(PrivateKey.Type.DSA)) {
                signAlg = SignatureAlgorithm.DSASignatureWithSHA1Digest;
            }
            MessageDigest SHADigest = null;
            byte[] digest = null;
            try {
                SHADigest = MessageDigest.getInstance("SHA1");
                digestAlg = DigestAlgorithm.SHA1;
                ByteArrayOutputStream ostream = new ByteArrayOutputStream();
                pkidata.encode((OutputStream)ostream);
                digest = SHADigest.digest(ostream.toByteArray());
            }
            catch (NoSuchAlgorithmException ostream) {
                // empty catch block
            }
            SignerInfo signInfo = new SignerInfo(si, null, null, OBJECT_IDENTIFIER.id_cct_PKIData, digest, signAlg, (org.mozilla.jss.crypto.PrivateKey)privKey);
            SET signInfos = new SET();
            signInfos.addElement((ASN1Value)signInfo);
            SET digestAlgs = new SET();
            if (digestAlg != null) {
                AlgorithmIdentifier ai = new AlgorithmIdentifier(digestAlg.toOID(), null);
                digestAlgs.addElement((ASN1Value)ai);
            }
            X509Certificate[] agentChain = manager.buildCertificateChain(signerCert);
            SET certs = new SET();
            for (int i = 0; i < agentChain.length; ++i) {
                ANY cert = new ANY(agentChain[i].getEncoded());
                certs.addElement((ASN1Value)cert);
            }
            SignedData req = new SignedData(digestAlgs, ci, certs, null, signInfos);
            fullEnrollmentReq = new ContentInfo(req);
            ByteArrayOutputStream bs = new ByteArrayOutputStream();
            PrintStream ps = new PrintStream(bs);
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            fullEnrollmentReq.encode((OutputStream)os);
            ps.print(Utils.base64encode((byte[])os.toByteArray(), (boolean)true));
            asciiBASE64Blob = bs.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        return asciiBASE64Blob;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] s) {
        String dValue = null;
        String nValue = null;
        String rValue = null;
        String pValue = null;
        FileOutputStream outputBlob = null;
        String mPath = ".";
        String mPrefix = "";
        boolean bWrongParam = false;
        if (s.length == 8) {
            int length = s.length;
            for (int i = 0; i < length; ++i) {
                if (s[i].equals("-d")) {
                    dValue = s[i + 1];
                } else if (s[i].equals("-n")) {
                    nValue = s[i + 1];
                } else if (s[i].equals("-r")) {
                    rValue = s[i + 1];
                } else if (s[i].equals("-p")) {
                    pValue = s[i + 1];
                }
                if (!s[i].equals("")) continue;
                bWrongParam = true;
            }
            if (dValue == null || nValue == null || rValue == null || pValue == null) {
                bWrongParam = true;
            } else if (dValue.length() == 0 || nValue.length() == 0 || rValue.length() == 0 || pValue.length() == 0) {
                bWrongParam = true;
            }
            if (bWrongParam) {
                System.out.println("Usage:  CMCEnroll -d <dir to NSS database> -n <nickname> -r <request PKCS#10 file name> -p <password>");
                System.exit(0);
            }
            try {
                mPath = dValue;
                System.out.println("cert/key prefix = " + mPrefix);
                System.out.println("path = " + mPath);
                InitializationValues vals = new InitializationValues(mPath, mPrefix, mPrefix, "secmod.db");
                CryptoManager.initialize((InitializationValues)vals);
                CryptoManager cm = CryptoManager.getInstance();
                CryptoToken token = cm.getInternalKeyStorageToken();
                Password pass = new Password(pValue.toCharArray());
                try {
                    token.login((PasswordCallback)pass);
                }
                finally {
                    pass.clear();
                }
                X509Certificate signerCert = null;
                signerCert = cm.findCertByNickname(nValue);
                BufferedReader inputBlob = null;
                try {
                    inputBlob = new BufferedReader(new InputStreamReader(new BufferedInputStream(new FileInputStream(rValue))));
                }
                catch (FileNotFoundException e) {
                    System.out.println("CMCEnroll:  can''t find file " + rValue + ":\n" + e);
                    return;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.exit(1);
                }
                String asciiBASE64BlobChunk = "";
                StringBuffer asciiBASE64Blob = new StringBuffer();
                try {
                    while ((asciiBASE64BlobChunk = inputBlob.readLine()) != null) {
                        if (asciiBASE64BlobChunk.startsWith(HEADER) || asciiBASE64BlobChunk.startsWith(TRAILER)) continue;
                        asciiBASE64Blob.append(asciiBASE64BlobChunk.trim());
                    }
                }
                catch (IOException e) {
                    System.out.println("CMCEnroll:  Unexpected BASE64 encoded error encountered in readLine():\n" + e);
                }
                try {
                    inputBlob.close();
                }
                catch (IOException e) {
                    System.out.println("CMCEnroll():  Unexpected BASE64 encoded error encountered in close():\n" + e);
                }
                Object asciiBASE64Blob_str = CMCEnroll.getCMCBlob(signerCert, cm, nValue, asciiBASE64Blob.toString());
                byte[] binaryBASE64Blob = Utils.base64decode((String)asciiBASE64Blob_str);
                try {
                    outputBlob = new FileOutputStream(rValue + ".out");
                }
                catch (IOException e) {
                    System.out.println("CMCEnroll:  unable to open file " + rValue + ".out for writing:\n" + e);
                    return;
                }
                System.out.println("-----BEGIN CERTIFICATE REQUEST-----");
                System.out.println(asciiBASE64Blob + "-----END CERTIFICATE REQUEST-----");
                try {
                    asciiBASE64Blob_str = "-----BEGIN CERTIFICATE REQUEST-----\n" + (String)asciiBASE64Blob_str + "-----END CERTIFICATE REQUEST-----";
                    outputBlob.write(((String)asciiBASE64Blob_str).getBytes());
                }
                catch (IOException e) {
                    System.out.println("CMCEnroll:  I/O error encountered during write():\n" + e);
                }
                try {
                    outputBlob.close();
                }
                catch (IOException e) {
                    System.out.println("CMCEnroll:  Unexpected error encountered while attempting to close() \n" + e);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                System.exit(1);
            }
            return;
        }
        System.out.println("Wrong number of parameters:" + s.length);
        System.out.println("Usage:  CMCEnroll -d <dir to NSS database> -n <nickname> -r <request PKCS#10 file name> -p <password>");
        bWrongParam = true;
    }
}

