/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmstools.tps.cert;

import com.netscape.certsrv.tps.cert.TPSCertClient;
import com.netscape.certsrv.tps.cert.TPSCertCollection;
import com.netscape.certsrv.tps.cert.TPSCertData;
import com.netscape.cmstools.cli.MainCLI;
import com.netscape.cmstools.tps.cert.TPSCertCLI;
import java.util.Collection;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.dogtagpki.cli.CLI;
import org.dogtagpki.cli.CommandCLI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TPSCertFindCLI
extends CommandCLI {
    public static Logger logger = LoggerFactory.getLogger(TPSCertFindCLI.class);
    public TPSCertCLI certCLI;

    public TPSCertFindCLI(TPSCertCLI certCLI) {
        super("find", "Find certificates", (CLI)certCLI);
        this.certCLI = certCLI;
    }

    public void printHelp() {
        formatter.printHelp(this.getFullName() + " [FILTER] [OPTIONS...]", this.options);
    }

    public void createOptions() {
        Option option = new Option(null, "token", true, "Token ID");
        option.setArgName("ID");
        this.options.addOption(option);
        option = new Option(null, "start", true, "Page start");
        option.setArgName("start");
        this.options.addOption(option);
        option = new Option(null, "size", true, "Page size");
        option.setArgName("size");
        this.options.addOption(option);
    }

    public void execute(CommandLine cmd) throws Exception {
        String[] cmdArgs = cmd.getArgs();
        String filter = cmdArgs.length > 0 ? cmdArgs[0] : null;
        String tokenID = cmd.getOptionValue("token");
        String string3 = cmd.getOptionValue("start");
        String string4 = cmd.getOptionValue("size");
        Integer start = null;
        Integer size = null;
        try {
            start = string3 == null ? null : Integer.valueOf(string3);
        }
        catch (NumberFormatException e) {
            throw new Exception("Invalid value for --start parameter: " + string3, e);
        }
        try {
            size = string4 == null ? null : Integer.valueOf(string4);
        }
        catch (NumberFormatException e) {
            throw new Exception("Invalid value for --size parameter: " + string4, e);
        }
        MainCLI mainCLI = (MainCLI)this.getRoot();
        mainCLI.init();
        TPSCertClient certClient = this.certCLI.getTPSCertClient();
        TPSCertCollection result = certClient.findCerts(filter, tokenID, start, size);
        MainCLI.printMessage(result.getTotal() + " entries matched");
        if (result.getTotal() == 0) {
            return;
        }
        Collection certs = result.getEntries();
        boolean first = true;
        for (TPSCertData certData : certs) {
            if (first) {
                first = false;
            } else {
                System.out.println();
            }
            TPSCertCLI.printCert(certData);
        }
        MainCLI.printMessage("Number of entries returned " + certs.size());
    }
}

