/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.dotnet.shared.sarif;

import javax.annotation.CheckForNull;
import javax.annotation.Nullable;

public class Location {
    private String absolutePath;
    private String message;
    private int startLine;
    private int startColumn;
    private int endLine;
    private int endColumn;

    Location(String absolutePath, @Nullable String message, int startLine, int startColumn, int endLine, int endColumn) {
        this.absolutePath = absolutePath;
        this.message = message;
        this.startLine = startLine;
        this.startColumn = startColumn;
        this.endLine = endLine;
        this.endColumn = endColumn;
    }

    public String getAbsolutePath() {
        return this.absolutePath;
    }

    @CheckForNull
    public String getMessage() {
        return this.message;
    }

    public int getStartLine() {
        return this.startLine;
    }

    public int getStartColumn() {
        return this.startColumn;
    }

    public int getEndLine() {
        return this.endLine;
    }

    public int getEndColumn() {
        return this.endColumn;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Location location = (Location)o;
        if (this.startLine != location.startLine || this.startColumn != location.startColumn || this.endLine != location.endLine || this.endColumn != location.endColumn) {
            return false;
        }
        return (this.absolutePath != null ? this.absolutePath.equals(location.absolutePath) : location.absolutePath == null) && (this.message != null ? this.message.equals(location.message) : location.message == null);
    }

    public int hashCode() {
        int result = this.absolutePath != null ? this.absolutePath.hashCode() : 0;
        result = 31 * result + (this.message != null ? this.message.hashCode() : 0);
        result = 31 * result + this.startLine;
        result = 31 * result + this.startColumn;
        result = 31 * result + this.endLine;
        result = 31 * result + this.endColumn;
        return result;
    }

    public String toString() {
        return "Location [absolutePath=" + this.absolutePath + ", message=" + this.message + ", startLine=" + this.startLine + ", startColumn=" + this.startColumn + ", endLine=" + this.endLine + ", endColumn=" + this.endColumn + "]";
    }
}

