/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.ldap;

import java.util.Map;
import javax.naming.NamingException;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchResult;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.security.Authenticator;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.plugins.ldap.CallbackHandlerImpl;
import org.sonar.plugins.ldap.ContextHelper;
import org.sonar.plugins.ldap.Krb5LoginConfiguration;
import org.sonar.plugins.ldap.LdapContextFactory;
import org.sonar.plugins.ldap.LdapUserMapping;

public class LdapAuthenticator
extends Authenticator {
    private static final Logger LOG = Loggers.get(LdapAuthenticator.class);
    private final Map<String, LdapContextFactory> contextFactories;
    private final Map<String, LdapUserMapping> userMappings;

    public LdapAuthenticator(Map<String, LdapContextFactory> contextFactories, Map<String, LdapUserMapping> userMappings) {
        this.contextFactories = contextFactories;
        this.userMappings = userMappings;
    }

    public boolean doAuthenticate(Authenticator.Context context) {
        return this.authenticate(context.getUsername(), context.getPassword());
    }

    public boolean authenticate(String login, String password) {
        for (String ldapKey : this.userMappings.keySet()) {
            boolean passwordValid;
            String principal;
            if (this.contextFactories.get(ldapKey).isSasl()) {
                principal = login;
            } else {
                SearchResult result;
                try {
                    result = this.userMappings.get(ldapKey).createSearch(this.contextFactories.get(ldapKey), login).findUnique();
                }
                catch (NamingException e) {
                    LOG.debug("User {} not found in server {}: {}", new Object[]{login, ldapKey, e.getMessage()});
                    continue;
                }
                if (result == null) {
                    LOG.debug("User {} not found in {}", (Object)login, (Object)ldapKey);
                    continue;
                }
                principal = result.getNameInNamespace();
            }
            if (!(passwordValid = this.contextFactories.get(ldapKey).isGssapi() ? this.checkPasswordUsingGssapi(principal, password, ldapKey) : this.checkPasswordUsingBind(principal, password, ldapKey))) continue;
            return true;
        }
        LOG.debug("User {} not found", (Object)login);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkPasswordUsingBind(String principal, String password, String ldapKey) {
        boolean bl;
        if (StringUtils.isEmpty((String)password)) {
            LOG.debug("Password is blank.");
            return false;
        }
        InitialDirContext context = null;
        try {
            context = this.contextFactories.get(ldapKey).createUserContext(principal, password);
            bl = true;
        }
        catch (NamingException e) {
            boolean bl2;
            try {
                LOG.debug("Password not valid for user {} in server {}: {}", new Object[]{principal, ldapKey, e.getMessage()});
                bl2 = false;
            }
            catch (Throwable throwable) {
                ContextHelper.closeQuietly(context);
                throw throwable;
            }
            ContextHelper.closeQuietly(context);
            return bl2;
        }
        ContextHelper.closeQuietly(context);
        return bl;
    }

    private boolean checkPasswordUsingGssapi(String principal, String password, String ldapKey) {
        LoginContext lc;
        Configuration.setConfiguration(new Krb5LoginConfiguration());
        try {
            lc = new LoginContext(((Object)((Object)this)).getClass().getName(), new CallbackHandlerImpl(principal, password));
            lc.login();
        }
        catch (LoginException e) {
            LOG.debug("Password not valid for {} in server {}: {}", new Object[]{principal, ldapKey, e.getMessage()});
            return false;
        }
        try {
            lc.logout();
        }
        catch (LoginException e) {
            LOG.warn("Logout fails", (Throwable)e);
        }
        return true;
    }
}

