/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks.hotspots;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.python.PythonCheck;
import org.sonar.python.api.PythonGrammar;
import org.sonar.python.api.PythonPunctuator;
import org.sonar.python.semantic.Symbol;

@Rule(key="S4507")
public class DebugModeCheck
extends PythonCheck {
    public static final String CHECK_KEY = "S4507";
    private static final String MESSAGE = "Make sure this debug feature is deactivated before delivering the code in production.";
    private static final Set<String> debugProperties = DebugModeCheck.immutableSet("DEBUG", "DEBUG_PROPAGATE_EXCEPTIONS");

    @Override
    public Set<AstNodeType> subscribedKinds() {
        return DebugModeCheck.immutableSet(PythonGrammar.CALL_EXPR, PythonGrammar.EXPRESSION_STMT);
    }

    @Override
    public void visitNode(AstNode node) {
        if (node.is(PythonGrammar.EXPRESSION_STMT)) {
            if (this.getContext().pythonFile().fileName().equals("global_settings.py") && node.hasDirectChildren(PythonPunctuator.ASSIGN)) {
                this.checkDebugAssignment(node);
            }
        } else {
            String functionName;
            AstNode attributeRef = node.getFirstChild(PythonGrammar.ATTRIBUTE_REF);
            AstNode argList = node.getFirstChild(PythonGrammar.ARGLIST);
            if (argList != null && attributeRef != null && this.getQualifiedName(attributeRef.getFirstChild()).equals("django.conf.settings") && (functionName = attributeRef.getLastChild(PythonGrammar.NAME).getTokenValue()).equals("configure")) {
                argList.getChildren(PythonGrammar.ARGUMENT).forEach(this::checkDebugAssignment);
            }
        }
    }

    private void checkDebugAssignment(AstNode node) {
        AstNode lhsExpression = node.getFirstChild(PythonGrammar.TESTLIST_STAR_EXPR, PythonGrammar.TEST);
        AstNode rhsExpression = node.getLastChild(PythonGrammar.TESTLIST_STAR_EXPR, PythonGrammar.TEST);
        if (lhsExpression != null && rhsExpression != null && debugProperties.contains(lhsExpression.getTokenValue()) && rhsExpression.getTokenValue().equals("True")) {
            this.addIssue(node, MESSAGE);
        }
    }

    private String getQualifiedName(AstNode node) {
        Symbol symbol = this.getContext().symbolTable().getSymbol(node);
        return symbol != null ? symbol.qualifiedName() : "";
    }
}

