/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.config;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.XmlClientConfigBuilder;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.util.Preconditions;
import java.io.InputStream;
import java.util.Properties;

public class ClientClasspathXmlConfig
extends ClientConfig {
    private static final ILogger LOGGER = Logger.getLogger(ClientClasspathXmlConfig.class);

    public ClientClasspathXmlConfig(String resource) {
        this(resource, System.getProperties());
    }

    public ClientClasspathXmlConfig(String resource, Properties properties) {
        this(Thread.currentThread().getContextClassLoader(), resource, properties);
    }

    public ClientClasspathXmlConfig(ClassLoader classLoader, String resource, Properties properties) {
        Preconditions.checkTrue((classLoader != null ? 1 : 0) != 0, (String)"classLoader can't be null");
        Preconditions.checkTrue((resource != null ? 1 : 0) != 0, (String)"resource can't be null");
        Preconditions.checkTrue((properties != null ? 1 : 0) != 0, (String)"properties can't be null");
        LOGGER.info("Configuring Hazelcast Client from '" + resource + "'.");
        InputStream in = classLoader.getResourceAsStream(resource);
        Preconditions.checkTrue((in != null ? 1 : 0) != 0, (String)("Specified resource '" + resource + "' could not be found!"));
        XmlClientConfigBuilder xmlClientConfigBuilder = new XmlClientConfigBuilder(in);
        xmlClientConfigBuilder.setProperties(properties);
        xmlClientConfigBuilder.build(this, classLoader);
    }
}

