/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.extension;

import java.util.List;
import org.sonar.api.platform.Server;
import org.sonar.api.platform.ServerStartHandler;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.api.utils.log.Profiler;
import org.sonar.core.platform.ComponentContainer;
import org.sonar.server.extension.CoreExtensionBridge;

public class CoreExtensionBootstraper
implements ServerStartHandler {
    private static final Logger LOGGER = Loggers.get(CoreExtensionBootstraper.class);
    private final ComponentContainer componentContainer;

    public CoreExtensionBootstraper(ComponentContainer componentContainer) {
        this.componentContainer = componentContainer;
    }

    public void onServerStart(Server server) {
        List bridges = this.componentContainer.getComponentsByType(CoreExtensionBridge.class);
        for (CoreExtensionBridge bridge : bridges) {
            Profiler profiler = Profiler.create((Logger)LOGGER).startInfo(String.format("Bootstrapping %s", bridge.getPluginName()));
            bridge.startPlugin(this.componentContainer);
            profiler.stopInfo();
        }
    }
}

