/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.issue.notification;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.SetMultimap;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.server.issue.notification.ChangesOnMyIssuesNotification;
import org.sonar.server.issue.notification.IssuesChangesNotification;
import org.sonar.server.issue.notification.IssuesChangesNotificationBuilder;
import org.sonar.server.issue.notification.IssuesChangesNotificationSerializer;
import org.sonar.server.issue.notification.NotificationWithProjectKeys;
import org.sonar.server.notification.EmailNotificationHandler;
import org.sonar.server.notification.NotificationDispatcherMetadata;
import org.sonar.server.notification.NotificationManager;
import org.sonar.server.notification.email.EmailNotificationChannel;

public class ChangesOnMyIssueNotificationHandler
extends EmailNotificationHandler<IssuesChangesNotification> {
    private static final String KEY = "ChangesOnMyIssue";
    private static final NotificationDispatcherMetadata METADATA = NotificationDispatcherMetadata.create("ChangesOnMyIssue").setProperty("globalNotification", String.valueOf(true)).setProperty("perProjectNotification", String.valueOf(true));
    private final NotificationManager notificationManager;
    private final IssuesChangesNotificationSerializer serializer;

    public ChangesOnMyIssueNotificationHandler(NotificationManager notificationManager, EmailNotificationChannel emailNotificationChannel, IssuesChangesNotificationSerializer serializer) {
        super(emailNotificationChannel);
        this.notificationManager = notificationManager;
        this.serializer = serializer;
    }

    @Override
    public Optional<NotificationDispatcherMetadata> getMetadata() {
        return Optional.of(METADATA);
    }

    public static NotificationDispatcherMetadata newMetadata() {
        return METADATA;
    }

    @Override
    public Class<IssuesChangesNotification> getNotificationClass() {
        return IssuesChangesNotification.class;
    }

    @Override
    public Set<EmailNotificationChannel.EmailDeliveryRequest> toEmailDeliveryRequests(Collection<IssuesChangesNotification> notifications) {
        Set notificationsWithPeerChangedIssues = notifications.stream().map(this.serializer::from).filter(t -> t.getIssues().stream().anyMatch(issue -> issue.getAssignee().isPresent() && ChangesOnMyIssueNotificationHandler.isPeerChanged(t.getChange(), issue))).map(NotificationWithProjectKeys::new).collect(Collectors.toSet());
        if (notificationsWithPeerChangedIssues.isEmpty()) {
            return ImmutableSet.of();
        }
        Set projectKeys = notificationsWithPeerChangedIssues.stream().flatMap(t -> t.getProjectKeys().stream()).collect(Collectors.toSet());
        if (projectKeys.size() == 1) {
            Set assigneesOfPeerChangedIssues = notificationsWithPeerChangedIssues.stream().flatMap(t -> t.getIssues().stream().filter(issue -> ChangesOnMyIssueNotificationHandler.isPeerChanged(t.getChange(), issue))).map(IssuesChangesNotificationBuilder.ChangedIssue::getAssignee).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
            Set<NotificationManager.EmailRecipient> subscribedAssignees = this.notificationManager.findSubscribedEmailRecipients(KEY, (String)projectKeys.iterator().next(), assigneesOfPeerChangedIssues.stream().map(IssuesChangesNotificationBuilder.User::getLogin).collect(Collectors.toSet()), NotificationManager.SubscriberPermissionsOnProject.ALL_MUST_HAVE_ROLE_USER);
            return (Set)subscribedAssignees.stream().flatMap(recipient -> notificationsWithPeerChangedIssues.stream().filter(notification -> !notification.getChange().isAuthorLogin(recipient.getLogin())).map(notification -> ChangesOnMyIssueNotificationHandler.toEmailDeliveryRequest(notification, recipient, projectKeys))).filter(Objects::nonNull).collect(MoreCollectors.toSet((int)notificationsWithPeerChangedIssues.size()));
        }
        SetMultimap assigneeLoginsOfPeerChangedIssuesByProjectKey = (SetMultimap)notificationsWithPeerChangedIssues.stream().flatMap(notification -> notification.getIssues().stream().filter(issue -> issue.getAssignee().isPresent()).filter(issue -> ChangesOnMyIssueNotificationHandler.isPeerChanged(notification.getChange(), issue))).collect(MoreCollectors.unorderedIndex(t -> t.getProject().getKey(), t -> t.getAssignee().get().getLogin()));
        SetMultimap authorizedAssigneeLoginsByProjectKey = (SetMultimap)assigneeLoginsOfPeerChangedIssuesByProjectKey.asMap().entrySet().stream().collect(MoreCollectors.unorderedFlattenIndex(Map.Entry::getKey, entry -> {
            String projectKey = (String)entry.getKey();
            Set assigneeLogins = (Set)entry.getValue();
            return this.notificationManager.findSubscribedEmailRecipients(KEY, projectKey, assigneeLogins, NotificationManager.SubscriberPermissionsOnProject.ALL_MUST_HAVE_ROLE_USER).stream();
        }));
        SetMultimap projectKeyByRecipient = (SetMultimap)authorizedAssigneeLoginsByProjectKey.entries().stream().collect(MoreCollectors.unorderedIndex(Map.Entry::getValue, Map.Entry::getKey));
        return (Set)projectKeyByRecipient.asMap().entrySet().stream().flatMap(entry -> {
            NotificationManager.EmailRecipient recipient = (NotificationManager.EmailRecipient)entry.getKey();
            Set subscribedProjectKeys = (Set)entry.getValue();
            return notificationsWithPeerChangedIssues.stream().filter(notification -> !notification.getChange().isAuthorLogin(recipient.getLogin())).map(notification -> ChangesOnMyIssueNotificationHandler.toEmailDeliveryRequest(notification, recipient, subscribedProjectKeys)).filter(Objects::nonNull);
        }).collect(MoreCollectors.toSet((int)notificationsWithPeerChangedIssues.size()));
    }

    @CheckForNull
    private static EmailNotificationChannel.EmailDeliveryRequest toEmailDeliveryRequest(NotificationWithProjectKeys notification, NotificationManager.EmailRecipient recipient, Set<String> subscribedProjectKeys) {
        Set recipientIssuesByProject = (Set)notification.getIssues().stream().filter(issue -> issue.getAssignee().filter(assignee -> recipient.getLogin().equals(assignee.getLogin())).isPresent()).filter(issue -> subscribedProjectKeys.contains(issue.getProject().getKey())).collect(MoreCollectors.toSet((int)notification.getIssues().size()));
        if (recipientIssuesByProject.isEmpty()) {
            return null;
        }
        return new EmailNotificationChannel.EmailDeliveryRequest(recipient.getEmail(), new ChangesOnMyIssuesNotification(notification.getChange(), recipientIssuesByProject));
    }

    private static boolean isPeerChanged(IssuesChangesNotificationBuilder.Change change, IssuesChangesNotificationBuilder.ChangedIssue issue) {
        Optional<IssuesChangesNotificationBuilder.User> assignee = issue.getAssignee();
        return !assignee.isPresent() || !change.isAuthorLogin(assignee.get().getLogin());
    }
}

