/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.issue.notification;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.ToIntFunction;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.sonar.api.notifications.Notification;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.rules.RuleType;
import org.sonar.api.utils.DateUtils;
import org.sonar.api.utils.Duration;
import org.sonar.api.utils.Durations;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.server.issue.notification.DistributedMetricStatsInt;
import org.sonar.server.issue.notification.MetricStatsInt;
import org.sonar.server.issue.notification.NewIssuesStatistics;

public class NewIssuesNotification
extends Notification {
    public static final String TYPE = "new-issues";
    private static final long serialVersionUID = -6305871981920103093L;
    private static final String COUNT = ".count";
    private static final String LABEL = ".label";
    private static final String DOT = ".";
    private final transient DetailsSupplier detailsSupplier;
    private final transient Durations durations;

    public NewIssuesNotification(Durations durations, DetailsSupplier detailsSupplier) {
        this(TYPE, durations, detailsSupplier);
    }

    protected NewIssuesNotification(String type, Durations durations, DetailsSupplier detailsSupplier) {
        super(type);
        this.durations = durations;
        this.detailsSupplier = detailsSupplier;
    }

    public NewIssuesNotification setAnalysisDate(Date d) {
        this.setFieldValue("projectDate", DateUtils.formatDateTime((Date)d));
        return this;
    }

    public NewIssuesNotification setProject(String projectKey, String projectName, @Nullable String branchName, @Nullable String pullRequest) {
        this.setFieldValue("projectName", projectName);
        this.setFieldValue("projectKey", projectKey);
        if (branchName != null) {
            this.setFieldValue("branch", branchName);
        }
        if (pullRequest != null) {
            this.setFieldValue("pullRequest", pullRequest);
        }
        return this;
    }

    @CheckForNull
    public String getProjectKey() {
        return this.getFieldValue("projectKey");
    }

    public NewIssuesNotification setProjectVersion(@Nullable String version) {
        if (version != null) {
            this.setFieldValue("projectVersion", version);
        }
        return this;
    }

    public NewIssuesNotification setStatistics(String projectName, NewIssuesStatistics.Stats stats) {
        this.setDefaultMessage(stats.getDistributedMetricStats(NewIssuesStatistics.Metric.RULE_TYPE).getOnLeak() + " new issues on " + projectName + ".\n");
        this.setRuleTypeStatistics(stats);
        this.setAssigneesStatistics(stats);
        this.setTagsStatistics(stats);
        this.setComponentsStatistics(stats);
        this.setRuleStatistics(stats);
        return this;
    }

    private void setRuleStatistics(NewIssuesStatistics.Stats stats) {
        NewIssuesStatistics.Metric metric = NewIssuesStatistics.Metric.RULE;
        List<Map.Entry<String, MetricStatsInt>> fiveBiggest = NewIssuesNotification.fiveBiggest(stats.getDistributedMetricStats(metric), MetricStatsInt::getOnLeak);
        int i = 1;
        for (Map.Entry<String, MetricStatsInt> ruleStats : fiveBiggest) {
            String ruleKey = ruleStats.getKey();
            RuleDefinition rule = this.detailsSupplier.getRuleDefinitionByRuleKey(RuleKey.parse((String)ruleKey)).orElseThrow(() -> new IllegalStateException(String.format("Rule with key '%s' does not exist", ruleKey)));
            String name = rule.getName() + " (" + rule.getLanguage() + ")";
            this.setFieldValue((Object)((Object)metric) + DOT + i + LABEL, name);
            this.setFieldValue((Object)((Object)metric) + DOT + i + COUNT, String.valueOf(ruleStats.getValue().getOnLeak()));
            ++i;
        }
    }

    private void setComponentsStatistics(NewIssuesStatistics.Stats stats) {
        NewIssuesStatistics.Metric metric = NewIssuesStatistics.Metric.COMPONENT;
        int i = 1;
        List<Map.Entry<String, MetricStatsInt>> fiveBiggest = NewIssuesNotification.fiveBiggest(stats.getDistributedMetricStats(metric), MetricStatsInt::getOnLeak);
        for (Map.Entry<String, MetricStatsInt> componentStats : fiveBiggest) {
            String uuid = componentStats.getKey();
            String componentName = this.detailsSupplier.getComponentNameByUuid(uuid).orElseThrow(() -> new IllegalStateException(String.format("Component with uuid '%s' not found", uuid)));
            this.setFieldValue((Object)((Object)metric) + DOT + i + LABEL, componentName);
            this.setFieldValue((Object)((Object)metric) + DOT + i + COUNT, String.valueOf(componentStats.getValue().getOnLeak()));
            ++i;
        }
    }

    private void setTagsStatistics(NewIssuesStatistics.Stats stats) {
        NewIssuesStatistics.Metric metric = NewIssuesStatistics.Metric.TAG;
        int i = 1;
        for (Map.Entry<String, MetricStatsInt> tagStats : NewIssuesNotification.fiveBiggest(stats.getDistributedMetricStats(metric), MetricStatsInt::getOnLeak)) {
            this.setFieldValue((Object)((Object)metric) + DOT + i + COUNT, String.valueOf(tagStats.getValue().getOnLeak()));
            this.setFieldValue((Object)((Object)metric) + DOT + i + LABEL, tagStats.getKey());
            ++i;
        }
    }

    private void setAssigneesStatistics(NewIssuesStatistics.Stats stats) {
        NewIssuesStatistics.Metric metric = NewIssuesStatistics.Metric.ASSIGNEE;
        List<Map.Entry<String, MetricStatsInt>> entries = NewIssuesNotification.fiveBiggest(stats.getDistributedMetricStats(metric), MetricStatsInt::getOnLeak);
        int i = 1;
        for (Map.Entry<String, MetricStatsInt> assigneeStats : entries) {
            String assigneeUuid = assigneeStats.getKey();
            String name = this.detailsSupplier.getUserNameByUuid(assigneeUuid).orElse(assigneeUuid);
            this.setFieldValue((Object)((Object)metric) + DOT + i + LABEL, name);
            this.setFieldValue((Object)((Object)metric) + DOT + i + COUNT, String.valueOf(assigneeStats.getValue().getOnLeak()));
            ++i;
        }
    }

    private static List<Map.Entry<String, MetricStatsInt>> fiveBiggest(DistributedMetricStatsInt distributedMetricStatsInt, ToIntFunction<MetricStatsInt> biggerCriteria) {
        Comparator<Map.Entry> comparator = Comparator.comparingInt(a -> biggerCriteria.applyAsInt((MetricStatsInt)a.getValue()));
        return (List)distributedMetricStatsInt.getForLabels().entrySet().stream().sorted(comparator.reversed()).limit(5L).collect(MoreCollectors.toList((int)5));
    }

    public NewIssuesNotification setDebt(Duration debt) {
        this.setFieldValue((Object)((Object)NewIssuesStatistics.Metric.EFFORT) + COUNT, this.durations.format(debt));
        return this;
    }

    private void setRuleTypeStatistics(NewIssuesStatistics.Stats stats) {
        DistributedMetricStatsInt distributedMetricStats = stats.getDistributedMetricStats(NewIssuesStatistics.Metric.RULE_TYPE);
        this.setFieldValue((Object)((Object)NewIssuesStatistics.Metric.RULE_TYPE) + COUNT, String.valueOf(distributedMetricStats.getOnLeak()));
        Arrays.stream(RuleType.values()).forEach(ruleType -> this.setFieldValue((Object)((Object)NewIssuesStatistics.Metric.RULE_TYPE) + DOT + ruleType + COUNT, String.valueOf(distributedMetricStats.getForLabel(ruleType.name()).map(MetricStatsInt::getOnLeak).orElse(0))));
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public int hashCode() {
        return super.hashCode();
    }

    @Immutable
    public static final class RuleDefinition {
        private final String name;
        private final String language;

        public RuleDefinition(String name, @Nullable String language) {
            this.name = Objects.requireNonNull(name, "name can't be null");
            this.language = language;
        }

        public String getName() {
            return this.name;
        }

        @CheckForNull
        public String getLanguage() {
            return this.language;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RuleDefinition that = (RuleDefinition)o;
            return this.name.equals(that.name) && Objects.equals(this.language, that.language);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.language);
        }

        public String toString() {
            return "RuleDefinition{" + this.name + " (" + this.language + ')' + '}';
        }
    }

    public static interface DetailsSupplier {
        public Optional<RuleDefinition> getRuleDefinitionByRuleKey(RuleKey var1);

        public Optional<String> getComponentNameByUuid(String var1);

        public Optional<String> getUserNameByUuid(String var1);
    }
}

