/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.issue.workflow;

import java.util.Comparator;
import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.core.issue.DefaultIssue;
import org.sonar.core.issue.FieldDiffs;
import org.sonar.server.issue.workflow.Function;

enum RestoreResolutionFunction implements Function
{
    INSTANCE;


    @Override
    public void execute(Function.Context context) {
        DefaultIssue defaultIssue = (DefaultIssue)context.issue();
        String previousResolution = defaultIssue.changes().stream().filter(change -> change != defaultIssue.currentChange()).filter(change -> change.creationDate() != null).sorted(Comparator.comparing(FieldDiffs::creationDate).reversed()).map(this::parse).filter(Objects::nonNull).filter(StatusAndResolutionDiffs::hasResolution).findFirst().map(t -> ((StatusAndResolutionDiffs)t).newStatusClosed ? ((StatusAndResolutionDiffs)t).oldResolution : ((StatusAndResolutionDiffs)t).newResolution).orElse(null);
        context.setResolution(previousResolution);
    }

    @CheckForNull
    private StatusAndResolutionDiffs parse(FieldDiffs fieldDiffs) {
        FieldDiffs.Diff status = fieldDiffs.get("status");
        if (status == null) {
            return null;
        }
        FieldDiffs.Diff resolution = fieldDiffs.get("resolution");
        if (resolution == null) {
            return new StatusAndResolutionDiffs("CLOSED".equals(status.newValue()), null, null);
        }
        return new StatusAndResolutionDiffs("CLOSED".equals(status.newValue()), (String)((Object)resolution.oldValue()), (String)((Object)resolution.newValue()));
    }

    private static class StatusAndResolutionDiffs {
        private final boolean newStatusClosed;
        private final String oldResolution;
        private final String newResolution;

        private StatusAndResolutionDiffs(boolean newStatusClosed, @Nullable String oldResolution, @Nullable String newResolution) {
            this.newStatusClosed = newStatusClosed;
            this.oldResolution = StatusAndResolutionDiffs.emptyToNull(oldResolution);
            this.newResolution = StatusAndResolutionDiffs.emptyToNull(newResolution);
        }

        private static String emptyToNull(@Nullable String str) {
            if (str == null || str.isEmpty()) {
                return null;
            }
            return str;
        }

        boolean hasResolution() {
            return this.oldResolution != null || this.newResolution != null;
        }
    }
}

