/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.measure.index;

import java.util.Map;
import java.util.Objects;

public class ProjectMeasuresStatistics {
    private final long projectCount;
    private final long ncloc;
    private final Map<String, Long> projectCountByLanguage;
    private final Map<String, Long> nclocByLanguage;

    private ProjectMeasuresStatistics(Builder builder) {
        this.projectCount = builder.projectCount;
        this.ncloc = builder.ncloc;
        this.projectCountByLanguage = builder.projectCountByLanguage;
        this.nclocByLanguage = builder.nclocByLanguage;
    }

    public long getProjectCount() {
        return this.projectCount;
    }

    @Deprecated
    public long getNcloc() {
        return this.ncloc;
    }

    public Map<String, Long> getProjectCountByLanguage() {
        return this.projectCountByLanguage;
    }

    public Map<String, Long> getNclocByLanguage() {
        return this.nclocByLanguage;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Long projectCount;
        private Long ncloc;
        private Map<String, Long> projectCountByLanguage;
        private Map<String, Long> nclocByLanguage;

        private Builder() {
        }

        public Builder setProjectCount(long projectCount) {
            this.projectCount = projectCount;
            return this;
        }

        public Builder setSum(String metric, long value) {
            if (!"ncloc".equals(metric)) {
                throw new IllegalStateException("Metric not supported: " + metric);
            }
            this.ncloc = value;
            return this;
        }

        public void setProjectCountByLanguage(Map<String, Long> projectCountByLanguage) {
            this.projectCountByLanguage = projectCountByLanguage;
        }

        public Builder setNclocByLanguage(Map<String, Long> nclocByLanguage) {
            this.nclocByLanguage = nclocByLanguage;
            return this;
        }

        public ProjectMeasuresStatistics build() {
            Objects.requireNonNull(this.projectCount);
            Objects.requireNonNull(this.ncloc);
            Objects.requireNonNull(this.projectCountByLanguage);
            Objects.requireNonNull(this.nclocByLanguage);
            return new ProjectMeasuresStatistics(this);
        }
    }
}

