/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.notification;

import com.google.common.collect.Multimap;
import java.util.Objects;
import java.util.Set;
import javax.annotation.concurrent.Immutable;
import org.sonar.api.notifications.Notification;
import org.sonar.api.notifications.NotificationChannel;
import org.sonar.server.notification.NotificationDispatcher;

public interface NotificationManager {
    public <T extends Notification> void scheduleForSending(T var1);

    public Multimap<String, NotificationChannel> findSubscribedRecipientsForDispatcher(NotificationDispatcher var1, String var2, SubscriberPermissionsOnProject var3);

    public Set<EmailRecipient> findSubscribedEmailRecipients(String var1, String var2, SubscriberPermissionsOnProject var3);

    public Set<EmailRecipient> findSubscribedEmailRecipients(String var1, String var2, Set<String> var3, SubscriberPermissionsOnProject var4);

    public static final class SubscriberPermissionsOnProject {
        public static final SubscriberPermissionsOnProject ALL_MUST_HAVE_ROLE_USER = new SubscriberPermissionsOnProject("user");
        private final String globalSubscribers;
        private final String projectSubscribers;

        public SubscriberPermissionsOnProject(String globalAndProjectSubscribers) {
            this(globalAndProjectSubscribers, globalAndProjectSubscribers);
        }

        public SubscriberPermissionsOnProject(String globalSubscribers, String projectSubscribers) {
            this.globalSubscribers = Objects.requireNonNull(globalSubscribers, "global subscribers's required permission can't be null");
            this.projectSubscribers = Objects.requireNonNull(projectSubscribers, "project subscribers's required permission can't be null");
        }

        public String getGlobalSubscribers() {
            return this.globalSubscribers;
        }

        public String getProjectSubscribers() {
            return this.projectSubscribers;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SubscriberPermissionsOnProject that = (SubscriberPermissionsOnProject)o;
            return this.globalSubscribers.equals(that.globalSubscribers) && this.projectSubscribers.equals(that.projectSubscribers);
        }

        public int hashCode() {
            return Objects.hash(this.globalSubscribers, this.projectSubscribers);
        }
    }

    @Immutable
    public static final class EmailRecipient {
        private final String login;
        private final String email;

        public EmailRecipient(String login, String email) {
            this.login = Objects.requireNonNull(login, "login can't be null");
            this.email = Objects.requireNonNull(email, "email can't be null");
        }

        public String getLogin() {
            return this.login;
        }

        public String getEmail() {
            return this.email;
        }

        public String toString() {
            return "EmailRecipient{'" + this.login + '\'' + ":'" + this.email + '\'' + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EmailRecipient that = (EmailRecipient)o;
            return this.login.equals(that.login) && this.email.equals(that.email);
        }

        public int hashCode() {
            return Objects.hash(this.login, this.email);
        }
    }
}

