/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.process;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.sonar.process.AesCipher;
import org.sonar.process.Base64Cipher;
import org.sonar.process.Cipher;

public final class Encryption {
    private static final String BASE64_ALGORITHM = "b64";
    private static final String AES_ALGORITHM = "aes";
    private final AesCipher aesCipher;
    private final Map<String, Cipher> ciphers = new HashMap<String, Cipher>();
    private static final Pattern ENCRYPTED_PATTERN = Pattern.compile("\\{(.*?)\\}(.*)");

    public Encryption(@Nullable String pathToSecretKey) {
        this.aesCipher = new AesCipher(pathToSecretKey);
        this.ciphers.put(BASE64_ALGORITHM, new Base64Cipher());
        this.ciphers.put(AES_ALGORITHM, this.aesCipher);
    }

    public boolean isEncrypted(String value) {
        return value.indexOf(123) == 0 && value.indexOf(125) > 1;
    }

    public String decrypt(String encryptedText) {
        Cipher cipher;
        Matcher matcher = ENCRYPTED_PATTERN.matcher(encryptedText);
        if (matcher.matches() && (cipher = this.ciphers.get(matcher.group(1).toLowerCase(Locale.ENGLISH))) != null) {
            return cipher.decrypt(matcher.group(2));
        }
        return encryptedText;
    }
}

