/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.process;

import java.io.File;
import java.util.Properties;
import java.util.function.BiConsumer;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.sonar.process.Encryption;

public class Props {
    private final Properties properties = new Properties();
    private final Encryption encryption;

    public Props(Properties props) {
        props.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> this.properties.put(k.toString().trim(), v == null ? null : v.toString().trim())));
        this.encryption = new Encryption(props.getProperty("sonar.secretKeyPath"));
    }

    public boolean contains(String key) {
        return this.properties.containsKey(key);
    }

    @CheckForNull
    public String value(String key) {
        String value = this.properties.getProperty(key);
        if (value != null && this.encryption.isEncrypted(value)) {
            value = this.encryption.decrypt(value);
        }
        return value;
    }

    public String nonNullValue(String key) {
        String value = this.value(key);
        if (value == null) {
            throw new IllegalArgumentException("Missing property: " + key);
        }
        return value;
    }

    @CheckForNull
    public String value(String key, @Nullable String defaultValue) {
        String s = this.value(key);
        return s == null ? defaultValue : s;
    }

    public boolean valueAsBoolean(String key) {
        String s = this.value(key);
        return s != null && Boolean.parseBoolean(s);
    }

    public boolean valueAsBoolean(String key, boolean defaultValue) {
        String s = this.value(key);
        return s != null ? Boolean.parseBoolean(s) : defaultValue;
    }

    public File nonNullValueAsFile(String key) {
        String s = this.value(key);
        if (s == null) {
            throw new IllegalArgumentException("Property " + key + " is not set");
        }
        return new File(s);
    }

    @CheckForNull
    public Integer valueAsInt(String key) {
        String s = this.value(key);
        if (s != null && !"".equals(s)) {
            try {
                return Integer.parseInt(s);
            }
            catch (NumberFormatException e) {
                throw new IllegalStateException("Value of property " + key + " is not an integer: " + s, e);
            }
        }
        return null;
    }

    public int valueAsInt(String key, int defaultValue) {
        Integer i = this.valueAsInt(key);
        return i == null ? defaultValue : i;
    }

    public Properties rawProperties() {
        return this.properties;
    }

    public Props set(String key, @Nullable String value) {
        if (value != null) {
            this.properties.setProperty(key, value);
        }
        return this;
    }

    public void setDefault(String key, String value) {
        String s = this.properties.getProperty(key);
        if (StringUtils.isBlank((String)s)) {
            this.properties.setProperty(key, value);
        }
    }
}

