/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.process.logging;

import ch.qos.logback.classic.Level;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.sonar.process.ProcessId;
import org.sonar.process.logging.LogDomain;

public final class LogLevelConfig {
    private static final String SONAR_LOG_LEVEL_PROPERTY = "sonar.log.level";
    private static final String PROCESS_NAME_PLACEHOLDER = "XXXX";
    private static final String SONAR_PROCESS_LOG_LEVEL_PROPERTY = "sonar.log.level.XXXX";
    private final Map<String, List<String>> configuredByProperties;
    private final Map<String, Level> configuredByHardcodedLevel;
    private final Set<String> offUnlessTrace;
    private final String rootLoggerName;

    private LogLevelConfig(Builder builder) {
        this.configuredByProperties = Collections.unmodifiableMap(builder.configuredByProperties);
        this.configuredByHardcodedLevel = Collections.unmodifiableMap(builder.configuredByHardcodedLevel);
        this.offUnlessTrace = Collections.unmodifiableSet(builder.offUnlessTrace);
        this.rootLoggerName = builder.rootLoggerName;
    }

    Map<String, List<String>> getConfiguredByProperties() {
        return this.configuredByProperties;
    }

    Map<String, Level> getConfiguredByHardcodedLevel() {
        return this.configuredByHardcodedLevel;
    }

    Set<String> getOffUnlessTrace() {
        return this.offUnlessTrace;
    }

    String getRootLoggerName() {
        return this.rootLoggerName;
    }

    public static Builder newBuilder(String rootLoggerName) {
        return new Builder(rootLoggerName);
    }

    public static final class Builder {
        private final Map<String, List<String>> configuredByProperties = new HashMap<String, List<String>>();
        private final Map<String, Level> configuredByHardcodedLevel = new HashMap<String, Level>();
        private final Set<String> offUnlessTrace = new HashSet<String>();
        private final String rootLoggerName;

        private Builder(String rootLoggerName) {
            this.rootLoggerName = Objects.requireNonNull(rootLoggerName, "rootLoggerName can't be null");
        }

        public Builder rootLevelFor(ProcessId processId) {
            Builder.checkProcessId(processId);
            this.levelByProperty(this.rootLoggerName, LogLevelConfig.SONAR_LOG_LEVEL_PROPERTY, LogLevelConfig.SONAR_PROCESS_LOG_LEVEL_PROPERTY.replace(LogLevelConfig.PROCESS_NAME_PLACEHOLDER, processId.getKey()));
            return this;
        }

        public Builder levelByDomain(String loggerName, ProcessId processId, LogDomain domain) {
            Builder.checkLoggerName(loggerName);
            Builder.checkProcessId(processId);
            Objects.requireNonNull(domain, "LogDomain can't be null");
            String processProperty = LogLevelConfig.SONAR_PROCESS_LOG_LEVEL_PROPERTY.replace(LogLevelConfig.PROCESS_NAME_PLACEHOLDER, processId.getKey());
            this.levelByProperty(loggerName, LogLevelConfig.SONAR_LOG_LEVEL_PROPERTY, processProperty, processProperty + "." + domain.getKey());
            return this;
        }

        private void levelByProperty(String loggerName, String property, String ... otherProperties) {
            this.ensureUniqueConfiguration(loggerName);
            this.configuredByProperties.put(loggerName, Stream.concat(Stream.of(property), Arrays.stream(otherProperties)).collect(Collectors.toList()));
        }

        public Builder immutableLevel(String loggerName, Level level) {
            Builder.checkLoggerName(loggerName);
            Objects.requireNonNull(level, "level can't be null");
            this.ensureUniqueConfiguration(loggerName);
            this.configuredByHardcodedLevel.put(loggerName, level);
            return this;
        }

        private void ensureUniqueConfiguration(String loggerName) {
            if (this.configuredByProperties.containsKey(loggerName)) {
                throw new IllegalStateException("Configuration by property already registered for " + loggerName);
            }
            if (this.configuredByHardcodedLevel.containsKey(loggerName)) {
                throw new IllegalStateException("Configuration hardcoded level already registered for " + loggerName);
            }
            if (this.offUnlessTrace.contains(loggerName)) {
                throw new IllegalStateException("Configuration off unless TRACE already registered for " + loggerName);
            }
        }

        private static void checkProcessId(ProcessId processId) {
            Objects.requireNonNull(processId, "ProcessId can't be null");
        }

        private static void checkLoggerName(String loggerName) {
            Objects.requireNonNull(loggerName, "loggerName can't be null");
            if (loggerName.isEmpty()) {
                throw new IllegalArgumentException("loggerName can't be empty");
            }
        }

        public Builder offUnlessTrace(String loggerName) {
            Builder.checkLoggerName(loggerName);
            this.ensureUniqueConfiguration(loggerName);
            this.offUnlessTrace.add(loggerName);
            return this;
        }

        public LogLevelConfig build() {
            return new LogLevelConfig(this);
        }
    }
}

