/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.html.checks.sonar;

import org.sonar.check.Rule;
import org.sonar.plugins.html.checks.AbstractPageCheck;
import org.sonar.plugins.html.node.TagNode;

@Rule(key="ImgWithoutWidthOrHeightCheck")
public class ImgWithoutWidthOrHeightCheck
extends AbstractPageCheck {
    @Override
    public void startElement(TagNode node) {
        if (!(!ImgWithoutWidthOrHeightCheck.isImgTag(node) && !ImgWithoutWidthOrHeightCheck.isImageInput(node) || node.hasProperty("WIDTH") && node.hasProperty("HEIGHT"))) {
            this.createViolation(node.getStartLinePosition(), "Add both a 'width' and a 'height' attribute to this image.");
        }
    }

    private static boolean isImgTag(TagNode node) {
        return "IMG".equalsIgnoreCase(node.getNodeName());
    }

    private static boolean isImageInput(TagNode node) {
        String type = node.getPropertyValue("TYPE");
        return "INPUT".equalsIgnoreCase(node.getNodeName()) && type != null && "IMAGE".equalsIgnoreCase(type);
    }
}

