/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.html.lex;

import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.sonar.channel.Channel;
import org.sonar.channel.ChannelDispatcher;
import org.sonar.channel.CodeReader;
import org.sonar.plugins.html.lex.AbstractTokenizer;
import org.sonar.plugins.html.lex.CdataTokenizer;
import org.sonar.plugins.html.lex.CommentTokenizer;
import org.sonar.plugins.html.lex.DirectiveTokenizer;
import org.sonar.plugins.html.lex.DoctypeTokenizer;
import org.sonar.plugins.html.lex.ExpressionTokenizer;
import org.sonar.plugins.html.lex.NormalElementTokenizer;
import org.sonar.plugins.html.lex.TextTokenizer;
import org.sonar.plugins.html.node.Node;
import org.sonar.plugins.html.node.NodeType;
import org.sonar.plugins.html.node.TagNode;

public final class PageLexer {
    private static List tokenizers = Arrays.asList(new CommentTokenizer("<!--", "-->", true), new CommentTokenizer("<%--", "--%>", false), new DoctypeTokenizer("<!DOCTYPE", ">"), new DirectiveTokenizer("<?", "?>"), new DirectiveTokenizer("<%@", "%>"), new ExpressionTokenizer("<%", "%>"), new CdataTokenizer(), new NormalElementTokenizer(), new TextTokenizer());

    public List<Node> nestedParse(CodeReader reader) {
        AbstractTokenizer tokenizer;
        ArrayList<Node> nodeList = new ArrayList<Node>();
        Iterator iterator = tokenizers.iterator();
        while (iterator.hasNext() && !(tokenizer = (AbstractTokenizer)iterator.next()).consume(reader, nodeList)) {
        }
        return nodeList;
    }

    public List<Node> parse(Reader reader) {
        CodeReader codeReader = new CodeReader(reader);
        ArrayList<Node> nodeList = new ArrayList<Node>();
        ChannelDispatcher<ArrayList<Node>> channelDispatcher = ChannelDispatcher.builder().addChannels(tokenizers.toArray(new Channel[tokenizers.size()])).build();
        channelDispatcher.consume(codeReader, nodeList);
        PageLexer.createNodeHierarchy(nodeList);
        return nodeList;
    }

    private static void createNodeHierarchy(List<Node> nodeList) {
        TagNode current = null;
        for (Node node : nodeList) {
            if (node.getNodeType() != NodeType.TAG) continue;
            TagNode element = (TagNode)node;
            if (!element.isEndElement()) {
                element.setParent(current);
                current = element;
            }
            if (!element.isEndElement() && !element.hasEnd() || current == null) continue;
            current = current.getParent();
        }
    }
}

