/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.queue;

import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.sonar.db.component.ComponentDto;

@Immutable
public final class CeTaskSubmit {
    private final String uuid;
    private final String type;
    private final Component component;
    private final String submitterUuid;
    private final Map<String, String> characteristics;

    private CeTaskSubmit(Builder builder) {
        this.uuid = Objects.requireNonNull(builder.uuid);
        this.type = Objects.requireNonNull(builder.type);
        this.component = builder.component;
        this.submitterUuid = builder.submitterUuid;
        this.characteristics = Collections.unmodifiableMap(builder.characteristics);
    }

    public String getType() {
        return this.type;
    }

    public String getUuid() {
        return this.uuid;
    }

    public Optional<Component> getComponent() {
        return Optional.ofNullable(this.component);
    }

    @CheckForNull
    public String getSubmitterUuid() {
        return this.submitterUuid;
    }

    public Map<String, String> getCharacteristics() {
        return this.characteristics;
    }

    public static class Component {
        private String uuid;
        private String mainComponentUuid;

        public Component(String uuid, String mainComponentUuid) {
            this.uuid = Objects.requireNonNull(Strings.nullToEmpty((String)uuid), "uuid can't be null");
            this.mainComponentUuid = Objects.requireNonNull(Strings.nullToEmpty((String)mainComponentUuid), "mainComponentUuid can't be null");
        }

        public static Component fromDto(ComponentDto dto) {
            String uuid = dto.uuid();
            return new Component(uuid, (String)MoreObjects.firstNonNull((Object)dto.getMainBranchProjectUuid(), (Object)uuid));
        }

        public String getUuid() {
            return this.uuid;
        }

        public String getMainComponentUuid() {
            return this.mainComponentUuid;
        }

        public String toString() {
            return "Component{uuid='" + this.uuid + '\'' + ", mainComponentUuid='" + this.mainComponentUuid + '\'' + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Component component = (Component)o;
            return this.uuid.equals(component.uuid) && this.mainComponentUuid.equals(component.mainComponentUuid);
        }

        public int hashCode() {
            return Objects.hash(this.uuid, this.mainComponentUuid);
        }
    }

    public static final class Builder {
        private final String uuid;
        private String type;
        private Component component;
        private String submitterUuid;
        private Map<String, String> characteristics = null;

        public Builder(String uuid) {
            this.uuid = Strings.emptyToNull((String)uuid);
        }

        public String getUuid() {
            return this.uuid;
        }

        public Builder setType(String s) {
            this.type = Strings.emptyToNull((String)s);
            return this;
        }

        public Builder setComponent(@Nullable Component component) {
            this.component = component;
            return this;
        }

        public Builder setSubmitterUuid(@Nullable String s) {
            this.submitterUuid = s;
            return this;
        }

        public Builder setCharacteristics(Map<String, String> m) {
            this.characteristics = m;
            return this;
        }

        public CeTaskSubmit build() {
            Objects.requireNonNull(this.uuid, "uuid can't be null");
            Objects.requireNonNull(this.type, "type can't be null");
            Objects.requireNonNull(this.characteristics, "characteristics can't be null");
            return new CeTaskSubmit(this);
        }
    }
}

