/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class CeTask {
    private final String organizationUuid;
    private final String type;
    private final String uuid;
    private final Component component;
    private final Component mainComponent;
    private final User submitter;
    private final Map<String, String> characteristics;

    private CeTask(Builder builder) {
        this.organizationUuid = Objects.requireNonNull(Strings.emptyToNull((String)builder.organizationUuid), "organizationUuid can't be null nor empty");
        this.uuid = Objects.requireNonNull(Strings.emptyToNull((String)builder.uuid), "uuid can't be null nor empty");
        this.type = Objects.requireNonNull(Strings.emptyToNull((String)builder.type), "type can't be null nor empty");
        Preconditions.checkArgument((builder.component == null == (builder.mainComponent == null) ? 1 : 0) != 0, (Object)"None or both component and main component must be non null");
        this.component = builder.component;
        this.mainComponent = builder.mainComponent;
        this.submitter = builder.submitter;
        this.characteristics = builder.characteristics == null ? Collections.emptyMap() : Collections.unmodifiableMap(new HashMap(builder.characteristics));
    }

    public String getOrganizationUuid() {
        return this.organizationUuid;
    }

    public String getUuid() {
        return this.uuid;
    }

    public String getType() {
        return this.type;
    }

    public Optional<Component> getComponent() {
        return Optional.ofNullable(this.component);
    }

    public Optional<Component> getMainComponent() {
        return Optional.ofNullable(this.mainComponent);
    }

    @CheckForNull
    public User getSubmitter() {
        return this.submitter;
    }

    public Map<String, String> getCharacteristics() {
        return this.characteristics;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("organizationUuid", (Object)this.organizationUuid).add("type", (Object)this.type).add("uuid", (Object)this.uuid).add("component", (Object)this.component).add("mainComponent", (Object)this.mainComponent).add("submitter", (Object)this.submitter).toString();
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CeTask ceTask = (CeTask)o;
        return this.uuid.equals(ceTask.uuid);
    }

    public int hashCode() {
        return this.uuid.hashCode();
    }

    public static final class Component {
        private final String uuid;
        @CheckForNull
        private final String key;
        @CheckForNull
        private final String name;

        public Component(String uuid, @Nullable String key, @Nullable String name) {
            this.uuid = Objects.requireNonNull(Strings.emptyToNull((String)uuid), "uuid can't be null nor empty");
            this.key = Strings.emptyToNull((String)key);
            this.name = Strings.emptyToNull((String)name);
        }

        public String getUuid() {
            return this.uuid;
        }

        public Optional<String> getKey() {
            return Optional.ofNullable(this.key);
        }

        public Optional<String> getName() {
            return Optional.ofNullable(this.name);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Component component = (Component)o;
            return Objects.equals(this.uuid, component.uuid) && Objects.equals(this.key, component.key) && Objects.equals(this.name, component.name);
        }

        public int hashCode() {
            return Objects.hash(this.uuid, this.key, this.name);
        }

        public String toString() {
            return "Component{uuid='" + this.uuid + '\'' + ", key='" + this.key + '\'' + ", name='" + this.name + '\'' + '}';
        }
    }

    public static final class Builder {
        private String organizationUuid;
        private String uuid;
        private String type;
        private Component component;
        private Component mainComponent;
        private User submitter;
        private Map<String, String> characteristics;

        public Builder setOrganizationUuid(String organizationUuid) {
            this.organizationUuid = organizationUuid;
            return this;
        }

        public boolean hasOrganizationUuid() {
            return this.organizationUuid != null;
        }

        public Builder setUuid(String uuid) {
            this.uuid = uuid;
            return this;
        }

        public Builder setType(String type) {
            this.type = type;
            return this;
        }

        public Builder setComponent(@Nullable Component component) {
            this.component = component;
            return this;
        }

        public Builder setMainComponent(@Nullable Component mainComponent) {
            this.mainComponent = mainComponent;
            return this;
        }

        public Builder setSubmitter(@Nullable User s) {
            this.submitter = s;
            return this;
        }

        public Builder setCharacteristics(@Nullable Map<String, String> m) {
            this.characteristics = m;
            return this;
        }

        public CeTask build() {
            return new CeTask(this);
        }
    }

    @Immutable
    public static final class User {
        private final String uuid;
        private final String login;

        public User(String uuid, @Nullable String login) {
            this.uuid = Objects.requireNonNull(uuid);
            this.login = Strings.emptyToNull((String)login);
        }

        public String getUuid() {
            return this.uuid;
        }

        @CheckForNull
        public String getLogin() {
            return this.login;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            User other = (User)o;
            return this.uuid.equals(other.uuid);
        }

        public String toString() {
            return "User{uuid='" + this.uuid + '\'' + ", login='" + this.login + '\'' + '}';
        }

        public int hashCode() {
            return this.uuid.hashCode();
        }
    }
}

