/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.log;

import java.util.Collection;
import java.util.Objects;
import org.sonar.ce.task.CeTask;
import org.sonar.ce.task.log.CeTaskMessages;
import org.sonar.core.util.UuidFactory;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.ce.CeTaskMessageDto;

public class CeTaskMessagesImpl
implements CeTaskMessages {
    private final DbClient dbClient;
    private final UuidFactory uuidFactory;
    private final CeTask ceTask;

    public CeTaskMessagesImpl(DbClient dbClient, UuidFactory uuidFactory, CeTask ceTask) {
        this.dbClient = dbClient;
        this.uuidFactory = uuidFactory;
        this.ceTask = ceTask;
    }

    @Override
    public void add(CeTaskMessages.Message message) {
        CeTaskMessagesImpl.checkMessage(message);
        try (DbSession dbSession = this.dbClient.openSession(false);){
            this.insert(dbSession, message);
            dbSession.commit();
        }
    }

    @Override
    public void addAll(Collection<CeTaskMessages.Message> messages) {
        if (messages.isEmpty()) {
            return;
        }
        messages.forEach(CeTaskMessagesImpl::checkMessage);
        try (DbSession dbSession = this.dbClient.openSession(true);){
            messages.forEach(message -> this.insert(dbSession, (CeTaskMessages.Message)message));
            dbSession.commit();
        }
    }

    public void insert(DbSession dbSession, CeTaskMessages.Message message) {
        this.dbClient.ceTaskMessageDao().insert(dbSession, new CeTaskMessageDto().setUuid(this.uuidFactory.create()).setTaskUuid(this.ceTask.getUuid()).setMessage(message.getText()).setCreatedAt(message.getTimestamp()));
    }

    private static void checkMessage(CeTaskMessages.Message message) {
        Objects.requireNonNull(message, "message can't be null");
    }
}

