/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.dotnet.shared.plugins.protobuf;

import com.google.protobuf.Parser;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonarsource.dotnet.shared.plugins.SensorContextUtils;
import org.sonarsource.dotnet.shared.plugins.protobuf.RawProtobufImporter;

public abstract class ProtobufImporter<T>
extends RawProtobufImporter<T> {
    private static final Logger LOG = Loggers.get(ProtobufImporter.class);
    private final Function<T, String> toFilePath;
    private final UnaryOperator<String> toRealPath;
    private final SensorContext context;
    private final Set<Path> filesProcessed = new HashSet<Path>();

    ProtobufImporter(Parser<T> parser, SensorContext context, Function<T, String> toFilePath, UnaryOperator<String> toRealPath) {
        super(parser);
        this.context = context;
        this.toFilePath = toFilePath;
        this.toRealPath = toRealPath;
    }

    @Override
    final void consume(T message) {
        String filePath = (String)this.toRealPath.apply(this.toFilePath.apply(message));
        InputFile inputFile = SensorContextUtils.toInputFile(this.context.fileSystem(), filePath);
        if (inputFile == null) {
            LOG.warn("File '{}' referenced by the protobuf '{}' does not exist in the analysis context", (Object)filePath, (Object)message.getClass().getSimpleName());
            return;
        }
        if (this.isProcessed(inputFile)) {
            LOG.debug("File '{}' was already processed. Skip it", (Object)inputFile);
            return;
        }
        this.consumeFor(inputFile, message);
    }

    abstract void consumeFor(InputFile var1, T var2);

    boolean isProcessed(InputFile inputFile) {
        return !this.filesProcessed.add(inputFile.path().toAbsolutePath());
    }
}

