/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.authentication;

import com.google.common.base.Strings;
import javax.annotation.CheckForNull;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.sonar.api.server.authentication.IdentityProvider;
import org.sonar.api.web.ServletFilter;
import org.sonar.server.authentication.AuthenticationError;
import org.sonar.server.authentication.IdentityProviderRepository;

public abstract class AuthenticationFilter
extends ServletFilter {
    static final String CALLBACK_PATH = "/oauth2/callback/";
    private final IdentityProviderRepository identityProviderRepository;

    public AuthenticationFilter(IdentityProviderRepository identityProviderRepository) {
        this.identityProviderRepository = identityProviderRepository;
    }

    @CheckForNull
    IdentityProvider resolveProviderOrHandleResponse(HttpServletRequest request, HttpServletResponse response, String path) {
        String requestUri = request.getRequestURI();
        String providerKey = AuthenticationFilter.extractKeyProvider(requestUri, request.getContextPath() + path);
        if (providerKey == null) {
            AuthenticationError.handleError(request, response, "No provider key found in URI");
            return null;
        }
        try {
            return this.identityProviderRepository.getEnabledByKey(providerKey);
        }
        catch (Exception e) {
            AuthenticationError.handleError(e, request, response, String.format("Failed to retrieve IdentityProvider for key '%s'", providerKey));
            return null;
        }
    }

    @CheckForNull
    private static String extractKeyProvider(String requestUri, String context) {
        String key;
        if (requestUri.contains(context) && !Strings.isNullOrEmpty((String)(key = requestUri.replace(context, "")))) {
            return key;
        }
        return null;
    }
}

