/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.badge.ws;

import com.google.common.io.Resources;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.sonar.api.measures.Metric;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.measure.LiveMeasureDto;
import org.sonar.server.badge.ws.ETagUtils;
import org.sonar.server.badge.ws.ProjectBadgesException;
import org.sonar.server.badge.ws.ProjectBadgesSupport;
import org.sonar.server.badge.ws.ProjectBadgesWsAction;
import org.sonar.server.badge.ws.SvgGenerator;
import org.sonar.server.exceptions.ForbiddenException;
import org.sonar.server.exceptions.NotFoundException;

public class QualityGateAction
implements ProjectBadgesWsAction {
    private final DbClient dbClient;
    private final ProjectBadgesSupport support;
    private final SvgGenerator svgGenerator;

    public QualityGateAction(DbClient dbClient, ProjectBadgesSupport support, SvgGenerator svgGenerator) {
        this.dbClient = dbClient;
        this.support = support;
        this.svgGenerator = svgGenerator;
    }

    public void define(WebService.NewController controller) {
        WebService.NewAction action = controller.createAction("quality_gate").setHandler((RequestHandler)this).setSince("7.1").setDescription("Generate badge for project's quality gate as an SVG.<br/>Requires 'Browse' permission on the specified project.").setResponseExample(Resources.getResource(this.getClass(), (String)"quality_gate-example.svg"));
        this.support.addProjectAndBranchParams(action);
    }

    public void handle(Request request, Response response) throws Exception {
        response.setHeader("Cache-Control", "no-cache");
        response.stream().setMediaType("image/svg+xml");
        try (DbSession dbSession = this.dbClient.openSession(false);){
            ComponentDto project = this.support.getComponent(dbSession, request);
            Metric.Level qualityGateStatus = this.getQualityGate(dbSession, project);
            String result = this.svgGenerator.generateQualityGate(qualityGateStatus);
            String eTag = ETagUtils.getETag(result);
            Optional requestedETag = request.header("If-None-Match");
            if (requestedETag.filter(eTag::equals).isPresent()) {
                response.stream().setStatus(304);
                return;
            }
            response.setHeader("ETag", eTag);
            IOUtils.write((String)result, (OutputStream)response.stream().output(), (Charset)StandardCharsets.UTF_8);
        }
        catch (ProjectBadgesException | ForbiddenException | NotFoundException e) {
            SimpleDateFormat sdf = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);
            response.setHeader("Expires", sdf.format(new Date()));
            IOUtils.write((String)this.svgGenerator.generateError(e.getMessage()), (OutputStream)response.stream().output(), (Charset)StandardCharsets.UTF_8);
        }
    }

    private Metric.Level getQualityGate(DbSession dbSession, ComponentDto project) {
        return Metric.Level.valueOf((String)this.dbClient.liveMeasureDao().selectMeasure(dbSession, project.uuid(), "alert_status").map(LiveMeasureDto::getTextValue).orElseThrow(() -> new ProjectBadgesException("Quality gate has not been found")));
    }
}

