/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.badge.ws;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.text.StrSubstitutor;
import org.sonar.api.config.Configuration;
import org.sonar.api.measures.Metric;
import org.sonar.api.server.ServerSide;
import org.sonar.process.ProcessProperties;

@ServerSide
public class SvgGenerator {
    private static final Map<Character, Integer> CHAR_LENGTH = ImmutableMap.builder().put((Object)Character.valueOf('0'), (Object)7).put((Object)Character.valueOf('1'), (Object)7).put((Object)Character.valueOf('2'), (Object)7).put((Object)Character.valueOf('3'), (Object)7).put((Object)Character.valueOf('4'), (Object)7).put((Object)Character.valueOf('5'), (Object)7).put((Object)Character.valueOf('6'), (Object)7).put((Object)Character.valueOf('7'), (Object)7).put((Object)Character.valueOf('8'), (Object)7).put((Object)Character.valueOf('9'), (Object)7).put((Object)Character.valueOf('a'), (Object)7).put((Object)Character.valueOf('b'), (Object)7).put((Object)Character.valueOf('c'), (Object)6).put((Object)Character.valueOf('d'), (Object)7).put((Object)Character.valueOf('e'), (Object)6).put((Object)Character.valueOf('f'), (Object)4).put((Object)Character.valueOf('g'), (Object)7).put((Object)Character.valueOf('h'), (Object)7).put((Object)Character.valueOf('i'), (Object)3).put((Object)Character.valueOf('j'), (Object)5).put((Object)Character.valueOf('k'), (Object)6).put((Object)Character.valueOf('l'), (Object)3).put((Object)Character.valueOf('m'), (Object)11).put((Object)Character.valueOf('n'), (Object)7).put((Object)Character.valueOf('o'), (Object)7).put((Object)Character.valueOf('p'), (Object)7).put((Object)Character.valueOf('q'), (Object)7).put((Object)Character.valueOf('r'), (Object)5).put((Object)Character.valueOf('s'), (Object)6).put((Object)Character.valueOf('t'), (Object)4).put((Object)Character.valueOf('u'), (Object)7).put((Object)Character.valueOf('v'), (Object)6).put((Object)Character.valueOf('w'), (Object)9).put((Object)Character.valueOf('x'), (Object)6).put((Object)Character.valueOf('y'), (Object)6).put((Object)Character.valueOf('z'), (Object)6).put((Object)Character.valueOf('A'), (Object)7).put((Object)Character.valueOf('B'), (Object)7).put((Object)Character.valueOf('C'), (Object)8).put((Object)Character.valueOf('D'), (Object)8).put((Object)Character.valueOf('E'), (Object)7).put((Object)Character.valueOf('F'), (Object)6).put((Object)Character.valueOf('G'), (Object)8).put((Object)Character.valueOf('H'), (Object)8).put((Object)Character.valueOf('I'), (Object)5).put((Object)Character.valueOf('J'), (Object)5).put((Object)Character.valueOf('K'), (Object)7).put((Object)Character.valueOf('L'), (Object)6).put((Object)Character.valueOf('M'), (Object)9).put((Object)Character.valueOf('N'), (Object)8).put((Object)Character.valueOf('O'), (Object)9).put((Object)Character.valueOf('P'), (Object)7).put((Object)Character.valueOf('Q'), (Object)9).put((Object)Character.valueOf('R'), (Object)8).put((Object)Character.valueOf('S'), (Object)7).put((Object)Character.valueOf('T'), (Object)7).put((Object)Character.valueOf('U'), (Object)8).put((Object)Character.valueOf('V'), (Object)10).put((Object)Character.valueOf('W'), (Object)10).put((Object)Character.valueOf('X'), (Object)7).put((Object)Character.valueOf('Y'), (Object)7).put((Object)Character.valueOf('Z'), (Object)7).put((Object)Character.valueOf('%'), (Object)12).put((Object)Character.valueOf(' '), (Object)4).put((Object)Character.valueOf('.'), (Object)4).put((Object)Character.valueOf('_'), (Object)7).put((Object)Character.valueOf('\''), (Object)3).build();
    private static final String TEMPLATES_SONARCLOUD = "templates/sonarcloud";
    private static final String TEMPLATES_SONARQUBE = "templates/sonarqube";
    private static final int MARGIN = 6;
    private static final int ICON_WIDTH = 20;
    private static final String PARAMETER_ICON_WIDTH_PLUS_MARGIN = "iconWidthPlusMargin";
    private static final String PARAMETER_TOTAL_WIDTH = "totalWidth";
    private static final String PARAMETER_LEFT_WIDTH = "leftWidth";
    private static final String PARAMETER_LEFT_WIDTH_PLUS_MARGIN = "leftWidthPlusMargin";
    private static final String PARAMETER_RIGHT_WIDTH = "rightWidth";
    private static final String PARAMETER_LABEL_WIDTH = "labelWidth";
    private static final String PARAMETER_VALUE_WIDTH = "valueWidth";
    private static final String PARAMETER_COLOR = "color";
    private static final String PARAMETER_LABEL = "label";
    private static final String PARAMETER_VALUE = "value";
    private final String errorTemplate;
    private final String badgeTemplate;
    private final Map<Metric.Level, String> qualityGateTemplates;

    public SvgGenerator(Configuration config) {
        boolean isOnSonarCloud = config.getBoolean(ProcessProperties.Property.SONARCLOUD_ENABLED.getKey()).orElse(false);
        String templatePath = isOnSonarCloud ? TEMPLATES_SONARCLOUD : TEMPLATES_SONARQUBE;
        this.errorTemplate = this.readTemplate("templates/error.svg");
        this.badgeTemplate = this.readTemplate(templatePath + "/badge.svg");
        this.qualityGateTemplates = ImmutableMap.of((Object)Metric.Level.OK, (Object)this.readTemplate(templatePath + "/quality_gate_passed.svg"), (Object)Metric.Level.WARN, (Object)this.readTemplate(templatePath + "/quality_gate_warn.svg"), (Object)Metric.Level.ERROR, (Object)this.readTemplate(templatePath + "/quality_gate_failed.svg"));
    }

    public String generateBadge(String label, String value, Color backgroundValueColor) {
        int labelWidth = SvgGenerator.computeWidth(label);
        int valueWidth = SvgGenerator.computeWidth(value);
        ImmutableMap values = ImmutableMap.builder().put((Object)PARAMETER_TOTAL_WIDTH, (Object)String.valueOf(44 + labelWidth + valueWidth)).put((Object)PARAMETER_LABEL_WIDTH, (Object)String.valueOf(labelWidth)).put((Object)PARAMETER_VALUE_WIDTH, (Object)String.valueOf(valueWidth)).put((Object)PARAMETER_LEFT_WIDTH, (Object)String.valueOf(32 + labelWidth)).put((Object)PARAMETER_LEFT_WIDTH_PLUS_MARGIN, (Object)String.valueOf(38 + labelWidth)).put((Object)PARAMETER_RIGHT_WIDTH, (Object)String.valueOf(12 + valueWidth)).put((Object)PARAMETER_ICON_WIDTH_PLUS_MARGIN, (Object)String.valueOf(26)).put((Object)PARAMETER_COLOR, (Object)backgroundValueColor.getValue()).put((Object)PARAMETER_LABEL, (Object)label).put((Object)PARAMETER_VALUE, (Object)value).build();
        StrSubstitutor strSubstitutor = new StrSubstitutor((Map)values);
        return strSubstitutor.replace(this.badgeTemplate);
    }

    public String generateQualityGate(Metric.Level level) {
        return this.qualityGateTemplates.get(level);
    }

    public String generateError(String error) {
        ImmutableMap values = ImmutableMap.of((Object)PARAMETER_TOTAL_WIDTH, (Object)String.valueOf(6 + SvgGenerator.computeWidth(error) + 6), (Object)PARAMETER_LABEL, (Object)error);
        StrSubstitutor strSubstitutor = new StrSubstitutor((Map)values);
        return strSubstitutor.replace(this.errorTemplate);
    }

    private static int computeWidth(String text) {
        return text.chars().mapToObj(i -> Character.valueOf((char)i)).mapToInt(c -> {
            Integer length = CHAR_LENGTH.get(c);
            Preconditions.checkState((length != null ? 1 : 0) != 0, (String)"Invalid character '%s'", (Object[])new Object[]{c});
            return length;
        }).sum();
    }

    private String readTemplate(String template) {
        try {
            return IOUtils.toString((URL)this.getClass().getResource(template), (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new IllegalStateException(String.format("Can't read svg template '%s'", template), e);
        }
    }

    static class Color {
        static final Color DEFAULT = new Color("#999");
        static final Color QUALITY_GATE_OK = new Color("#4c1");
        static final Color QUALITY_GATE_WARN = new Color("#ed7d20");
        static final Color QUALITY_GATE_ERROR = new Color("#d4333f");
        static final Color RATING_A = new Color("#00aa00");
        static final Color RATING_B = new Color("#b0d513");
        static final Color RATING_C = new Color("#eabe06");
        static final Color RATING_D = new Color("#ed7d20");
        static final Color RATING_E = new Color("#e00");
        private final String value;

        private Color(String value) {
            this.value = value;
        }

        String getValue() {
            return this.value;
        }
    }
}

