/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.branch.pr.ws;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.protobuf.Message;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.api.utils.DateUtils;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.BranchDto;
import org.sonar.db.component.BranchType;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.component.SnapshotDto;
import org.sonar.db.measure.LiveMeasureDto;
import org.sonar.db.permission.OrganizationPermission;
import org.sonar.db.protobuf.DbProjectBranches;
import org.sonar.server.branch.pr.ws.PullRequestWsAction;
import org.sonar.server.branch.pr.ws.PullRequestsWs;
import org.sonar.server.component.ComponentFinder;
import org.sonar.server.issue.index.BranchStatistics;
import org.sonar.server.issue.index.IssueIndex;
import org.sonar.server.user.AbstractUserSession;
import org.sonar.server.user.UserSession;
import org.sonar.server.ws.WsUtils;
import org.sonarqube.ws.ProjectPullRequests;

public class ListAction
implements PullRequestWsAction {
    private final DbClient dbClient;
    private final UserSession userSession;
    private final ComponentFinder componentFinder;
    private final IssueIndex issueIndex;

    public ListAction(DbClient dbClient, UserSession userSession, ComponentFinder componentFinder, IssueIndex issueIndex) {
        this.dbClient = dbClient;
        this.userSession = userSession;
        this.componentFinder = componentFinder;
        this.issueIndex = issueIndex;
    }

    public void define(WebService.NewController context) {
        WebService.NewAction action = context.createAction("list").setSince("7.1").setDescription("List the pull requests of a project.<br/>One of the following permissions is required: <ul><li>'Browse' rights on the specified project</li><li>'Execute Analysis' rights on the specified project</li></ul>").setResponseExample(this.getClass().getResource("list-example.json")).setHandler((RequestHandler)this);
        PullRequestsWs.addProjectParam(action);
    }

    public void handle(Request request, Response response) throws Exception {
        String projectKey = request.mandatoryParam("project");
        try (DbSession dbSession = this.dbClient.openSession(false);){
            ComponentDto project = this.componentFinder.getByKey(dbSession, projectKey);
            this.checkPermission(project);
            Preconditions.checkArgument((project.isEnabled() && "TRK".equals(project.qualifier()) ? 1 : 0) != 0, (Object)"Invalid project key");
            List pullRequests = (List)this.dbClient.branchDao().selectByComponent(dbSession, project).stream().filter(b -> b.getBranchType() == BranchType.PULL_REQUEST).collect(MoreCollectors.toList());
            List pullRequestUuids = (List)pullRequests.stream().map(BranchDto::getUuid).collect(MoreCollectors.toList());
            Map mergeBranchesByUuid = (Map)this.dbClient.branchDao().selectByUuids(dbSession, (Collection)pullRequests.stream().map(BranchDto::getMergeBranchUuid).filter(Objects::nonNull).collect(MoreCollectors.toList())).stream().collect(MoreCollectors.uniqueIndex(BranchDto::getUuid));
            Map branchStatisticsByBranchUuid = (Map)this.issueIndex.searchBranchStatistics(project.uuid(), pullRequestUuids).stream().collect(MoreCollectors.uniqueIndex(BranchStatistics::getBranchUuid, Function.identity()));
            Map qualityGateMeasuresByComponentUuids = (Map)this.dbClient.liveMeasureDao().selectByComponentUuidsAndMetricKeys(dbSession, (Collection)pullRequestUuids, Collections.singletonList("alert_status")).stream().collect(MoreCollectors.uniqueIndex(LiveMeasureDto::getComponentUuid));
            Map analysisDateByBranchUuid = (Map)this.dbClient.snapshotDao().selectLastAnalysesByRootComponentUuids(dbSession, (Collection)pullRequestUuids).stream().collect(MoreCollectors.uniqueIndex(SnapshotDto::getComponentUuid, s -> DateUtils.formatDateTime((long)s.getCreatedAt())));
            ProjectPullRequests.ListWsResponse.Builder protobufResponse = ProjectPullRequests.ListWsResponse.newBuilder();
            pullRequests.forEach(b -> ListAction.addPullRequest(protobufResponse, b, mergeBranchesByUuid, (LiveMeasureDto)qualityGateMeasuresByComponentUuids.get(b.getUuid()), (BranchStatistics)branchStatisticsByBranchUuid.get(b.getUuid()), (String)analysisDateByBranchUuid.get(b.getUuid())));
            WsUtils.writeProtobuf((Message)protobufResponse.build(), request, response);
        }
    }

    private void checkPermission(ComponentDto component) {
        if (this.userSession.hasComponentPermission("user", component) || this.userSession.hasComponentPermission("scan", component) || this.userSession.hasPermission(OrganizationPermission.SCAN, component.getOrganizationUuid())) {
            return;
        }
        throw AbstractUserSession.insufficientPrivilegesException();
    }

    private static void addPullRequest(ProjectPullRequests.ListWsResponse.Builder response, BranchDto branch, Map<String, BranchDto> mergeBranchesByUuid, @Nullable LiveMeasureDto qualityGateMeasure, BranchStatistics branchStatistics, @Nullable String analysisDate) {
        Optional<BranchDto> mergeBranch = Optional.ofNullable(mergeBranchesByUuid.get(branch.getMergeBranchUuid()));
        ProjectPullRequests.PullRequest.Builder builder = ProjectPullRequests.PullRequest.newBuilder();
        builder.setKey(branch.getKey());
        DbProjectBranches.PullRequestData pullRequestData = Objects.requireNonNull(branch.getPullRequestData(), "Pull request data should be available for branch type PULL_REQUEST");
        builder.setBranch(pullRequestData.getBranch());
        Optional.ofNullable(Strings.emptyToNull((String)pullRequestData.getUrl())).ifPresent(arg_0 -> ((ProjectPullRequests.PullRequest.Builder)builder).setUrl(arg_0));
        Optional.ofNullable(Strings.emptyToNull((String)pullRequestData.getTitle())).ifPresent(arg_0 -> ((ProjectPullRequests.PullRequest.Builder)builder).setTitle(arg_0));
        if (mergeBranch.isPresent()) {
            String mergeBranchKey = mergeBranch.get().getKey();
            builder.setBase(mergeBranchKey);
        } else {
            builder.setIsOrphan(true);
        }
        if (StringUtils.isNotEmpty((String)pullRequestData.getTarget())) {
            builder.setTarget(pullRequestData.getTarget());
        } else if (mergeBranch.isPresent()) {
            builder.setTarget(mergeBranch.get().getKey());
        }
        Optional.ofNullable(analysisDate).ifPresent(arg_0 -> ((ProjectPullRequests.PullRequest.Builder)builder).setAnalysisDate(arg_0));
        ListAction.setQualityGate(builder, qualityGateMeasure, branchStatistics);
        response.addPullRequests(builder);
    }

    private static void setQualityGate(ProjectPullRequests.PullRequest.Builder builder, @Nullable LiveMeasureDto qualityGateMeasure, @Nullable BranchStatistics branchStatistics) {
        ProjectPullRequests.Status.Builder statusBuilder = ProjectPullRequests.Status.newBuilder();
        if (qualityGateMeasure != null) {
            Optional.ofNullable(qualityGateMeasure.getDataAsString()).ifPresent(arg_0 -> ((ProjectPullRequests.Status.Builder)statusBuilder).setQualityGateStatus(arg_0));
        }
        statusBuilder.setBugs(branchStatistics == null ? 0L : branchStatistics.getBugs());
        statusBuilder.setVulnerabilities(branchStatistics == null ? 0L : branchStatistics.getVulnerabilities());
        statusBuilder.setCodeSmells(branchStatistics == null ? 0L : branchStatistics.getCodeSmells());
        builder.setStatus(statusBuilder);
    }
}

