/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.ce.ws;

import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.ce.queue.CeQueue;
import org.sonar.server.ce.ws.CeWsAction;
import org.sonar.server.user.AbstractUserSession;
import org.sonar.server.user.SystemPasscode;
import org.sonar.server.user.UserSession;

public class PauseAction
implements CeWsAction {
    private final UserSession userSession;
    private final SystemPasscode systemPasscode;
    private final CeQueue ceQueue;

    public PauseAction(UserSession userSession, SystemPasscode systemPasscode, CeQueue ceQueue) {
        this.userSession = userSession;
        this.systemPasscode = systemPasscode;
        this.ceQueue = ceQueue;
    }

    @Override
    public void define(WebService.NewController controller) {
        controller.createAction("pause").setDescription("Requests pause of Compute Engine workers. Requires the system administration permission or system passcode (see sonar.web.systemPasscode in sonar.properties).").setSince("7.2").setInternal(true).setHandler((RequestHandler)this).setPost(true);
    }

    public void handle(Request request, Response response) throws Exception {
        if (!this.systemPasscode.isValid(request) && !this.userSession.isSystemAdministrator()) {
            throw AbstractUserSession.insufficientPrivilegesException();
        }
        this.ceQueue.pauseWorkers();
    }
}

