/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.measure.ws;

import java.util.Optional;
import javax.annotation.Nullable;
import org.sonar.api.utils.DateUtils;
import org.sonar.db.component.SnapshotDto;
import org.sonarqube.ws.Measures;

class SnapshotDtoToWsPeriod {
    private SnapshotDtoToWsPeriod() {
    }

    static Optional<Measures.Period> snapshotToWsPeriods(@Nullable SnapshotDto snapshot) {
        if (snapshot == null) {
            return Optional.empty();
        }
        if (snapshot.getPeriodDate() != null) {
            return Optional.of(SnapshotDtoToWsPeriod.snapshotDtoToWsPeriod(snapshot));
        }
        return Optional.empty();
    }

    private static Measures.Period snapshotDtoToWsPeriod(SnapshotDto snapshot) {
        Long periodDate;
        String periodModeParameter;
        Measures.Period.Builder period = Measures.Period.newBuilder();
        period.setIndex(1);
        String periodMode = snapshot.getPeriodMode();
        if (periodMode != null) {
            period.setMode(periodMode);
        }
        if ((periodModeParameter = snapshot.getPeriodModeParameter()) != null) {
            period.setParameter(periodModeParameter);
        }
        if ((periodDate = snapshot.getPeriodDate()) != null) {
            period.setDate(DateUtils.formatDateTime((long)periodDate));
        }
        return period.build();
    }
}

