/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.metric.ws;

import com.google.common.base.Preconditions;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.api.measures.Metric;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.api.utils.text.JsonWriter;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.measure.custom.CustomMeasureDto;
import org.sonar.db.metric.MetricDto;
import org.sonar.server.metric.ws.MetricsWsAction;
import org.sonar.server.user.UserSession;
import org.sonar.server.util.MetricKeyValidator;
import org.sonar.server.ws.WsUtils;

public class CreateAction
implements MetricsWsAction {
    private static final String ACTION = "create";
    public static final String PARAM_NAME = "name";
    public static final String PARAM_KEY = "key";
    public static final String PARAM_TYPE = "type";
    public static final String PARAM_DESCRIPTION = "description";
    public static final String PARAM_DOMAIN = "domain";
    private static final String FIELD_ID = "id";
    private static final String FIELD_NAME = "name";
    private static final String FIELD_KEY = "key";
    private static final String FIELD_TYPE = "type";
    private static final String FIELD_DESCRIPTION = "description";
    private static final String FIELD_DOMAIN = "domain";
    private final DbClient dbClient;
    private final UserSession userSession;

    public CreateAction(DbClient dbClient, UserSession userSession) {
        this.dbClient = dbClient;
        this.userSession = userSession;
    }

    public void define(WebService.NewController context) {
        WebService.NewAction action = context.createAction(ACTION).setPost(true).setDescription("Create custom metric.<br/>Requires 'Administer System' permission.").setDeprecatedSince("7.7").setSince("5.2").setHandler((RequestHandler)this);
        action.createParam("key").setRequired(true).setMaximumLength(Integer.valueOf(64)).setDescription("Key").setExampleValue((Object)"team_size");
        action.createParam("name").setRequired(true).setMaximumLength(Integer.valueOf(64)).setDescription("Name").setExampleValue((Object)"Team Size");
        action.createParam("type").setRequired(true).setDescription("Metric type key").setPossibleValues((Object[])Metric.ValueType.names()).setExampleValue((Object)Metric.ValueType.INT.name());
        action.createParam("description").setDescription("Description").setMaximumLength(Integer.valueOf(255)).setExampleValue((Object)"Size of the team");
        action.createParam("domain").setMaximumLength(Integer.valueOf(64)).setDescription("Domain").setExampleValue((Object)"Tests");
    }

    public void handle(Request request, Response response) throws Exception {
        this.userSession.checkLoggedIn().checkIsSystemAdministrator();
        String key = request.mandatoryParam("key");
        try (DbSession dbSession = this.dbClient.openSession(false);){
            MetricDto metricTemplate = CreateAction.newMetricTemplate(request);
            MetricDto metricInDb = this.dbClient.metricDao().selectByKey(dbSession, key);
            this.checkMetricInDbAndTemplate(dbSession, metricInDb, metricTemplate);
            if (CreateAction.metricIsNotInDb(metricInDb)) {
                metricInDb = this.insertNewMetric(dbSession, metricTemplate);
            } else {
                this.updateMetric(dbSession, metricInDb, metricTemplate);
            }
            JsonWriter json = response.newJsonWriter();
            CreateAction.writeMetric(json, metricInDb);
            json.close();
        }
    }

    private static MetricDto newMetricTemplate(Request request) {
        String key = MetricKeyValidator.checkMetricKeyFormat(request.mandatoryParam("key"));
        String name = request.mandatoryParam("name");
        String type = Metric.ValueType.valueOf((String)request.mandatoryParam("type")).name();
        String domain = request.param("domain");
        String description = request.param("description");
        MetricDto metricTemplate = new MetricDto().setKey(key).setShortName(name).setValueType(type);
        if (domain != null) {
            metricTemplate.setDomain(domain);
        }
        if (description != null) {
            metricTemplate.setDescription(description);
        }
        return metricTemplate;
    }

    private void updateMetric(DbSession dbSession, MetricDto metricInDb, MetricDto metricTemplate) {
        metricInDb.setShortName(metricTemplate.getShortName()).setValueType(metricTemplate.getValueType()).setDomain(metricTemplate.getDomain()).setDescription(metricTemplate.getDescription()).setEnabled(true);
        this.dbClient.metricDao().update(dbSession, metricInDb);
        dbSession.commit();
    }

    private MetricDto insertNewMetric(DbSession dbSession, MetricDto metricTemplate) {
        MetricDto metric = new MetricDto().setKey(metricTemplate.getKey()).setShortName(metricTemplate.getShortName()).setValueType(metricTemplate.getValueType()).setDomain(metricTemplate.getDomain()).setDescription(metricTemplate.getDescription()).setEnabled(true).setUserManaged(true).setDirection(0).setQualitative(false).setHidden(false).setOptimizedBestValue(false).setDeleteHistoricalData(false);
        this.dbClient.metricDao().insert(dbSession, metric);
        dbSession.commit();
        return metric;
    }

    private void checkMetricInDbAndTemplate(DbSession dbSession, @Nullable MetricDto metricInDb, MetricDto template) {
        Preconditions.checkArgument((!CreateAction.areOneOfTheMandatoryArgumentsEmpty(template) ? 1 : 0) != 0, (String)"The mandatory arguments '%s','%s' and '%s' must not be empty", (Object[])new Object[]{"key", "name", "type"});
        if (CreateAction.metricIsNotInDb(metricInDb)) {
            return;
        }
        WsUtils.checkRequest(!CreateAction.isMetricEnabled(metricInDb), "An active metric already exist with key: " + metricInDb.getKey(), new Object[0]);
        WsUtils.checkRequest(!CreateAction.isMetricNonCustom(metricInDb), "An non custom metric already exist with key: %s", metricInDb.getKey());
        if (CreateAction.hasMetricTypeChanged(metricInDb, template)) {
            List customMeasures = this.dbClient.customMeasureDao().selectByMetricId(dbSession, metricInDb.getId().intValue());
            WsUtils.checkRequest(!CreateAction.hasAssociatedCustomMeasures(customMeasures), "You're trying to change the type '%s' while there are associated measures.", metricInDb.getValueType());
        }
    }

    private static boolean hasAssociatedCustomMeasures(List<CustomMeasureDto> customMeasures) {
        return !customMeasures.isEmpty();
    }

    private static boolean hasMetricTypeChanged(MetricDto metricInDb, MetricDto template) {
        return !metricInDb.getValueType().equals(template.getValueType());
    }

    private static boolean isMetricNonCustom(MetricDto metricInDb) {
        return !metricInDb.isUserManaged();
    }

    private static boolean isMetricEnabled(MetricDto metricInDb) {
        return metricInDb.isEnabled();
    }

    private static boolean metricIsNotInDb(@Nullable MetricDto metricInDb) {
        return metricInDb == null;
    }

    private static boolean areOneOfTheMandatoryArgumentsEmpty(MetricDto template) {
        return template.getValueType().isEmpty() || template.getShortName().isEmpty() || template.getKey().isEmpty();
    }

    private static void writeMetric(JsonWriter json, MetricDto metric) {
        json.beginObject();
        json.prop(FIELD_ID, metric.getId().toString());
        json.prop("key", metric.getKey());
        json.prop("name", metric.getShortName());
        json.prop("type", metric.getValueType());
        json.prop("domain", metric.getDomain());
        json.prop("description", metric.getDescription());
        json.endObject();
    }
}

