/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.permission.ws.template;

import com.google.common.collect.Lists;
import com.google.common.collect.Table;
import com.google.common.collect.TreeBasedTable;
import com.google.protobuf.Message;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.ibatis.session.ResultContext;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.api.utils.DateUtils;
import org.sonar.core.i18n.I18n;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.organization.DefaultTemplates;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.db.permission.template.CountByTemplateAndPermissionDto;
import org.sonar.db.permission.template.PermissionTemplateCharacteristicDto;
import org.sonar.db.permission.template.PermissionTemplateDto;
import org.sonar.server.permission.PermissionPrivilegeChecker;
import org.sonar.server.permission.PermissionService;
import org.sonar.server.permission.ws.PermissionWsSupport;
import org.sonar.server.permission.ws.PermissionsWsAction;
import org.sonar.server.permission.ws.WsParameters;
import org.sonar.server.permission.ws.template.DefaultTemplatesResolver;
import org.sonar.server.permission.ws.template.SearchTemplatesData;
import org.sonar.server.user.UserSession;
import org.sonar.server.ws.WsUtils;
import org.sonarqube.ws.Permissions;

public class SearchTemplatesAction
implements PermissionsWsAction {
    private static final String PROPERTY_PREFIX = "projects_role.";
    private static final String DESCRIPTION_SUFFIX = ".desc";
    private final DbClient dbClient;
    private final UserSession userSession;
    private final I18n i18n;
    private final PermissionWsSupport wsSupport;
    private final DefaultTemplatesResolver defaultTemplatesResolver;
    private final PermissionService permissionService;

    public SearchTemplatesAction(DbClient dbClient, UserSession userSession, I18n i18n, PermissionWsSupport wsSupport, DefaultTemplatesResolver defaultTemplatesResolver, PermissionService permissionService) {
        this.dbClient = dbClient;
        this.userSession = userSession;
        this.i18n = i18n;
        this.wsSupport = wsSupport;
        this.defaultTemplatesResolver = defaultTemplatesResolver;
        this.permissionService = permissionService;
    }

    public void define(WebService.NewController context) {
        WebService.NewAction action = context.createAction("search_templates").setDescription("List permission templates.<br />Requires the following permission: 'Administer System'.").setResponseExample(this.getClass().getResource("search_templates-example.json")).setSince("5.2").addSearchQuery("defau", new String[]{"permission template names"}).setHandler((RequestHandler)this);
        WsParameters.createOrganizationParameter(action).setSince("6.2");
    }

    public void handle(Request wsRequest, Response wsResponse) throws Exception {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            OrganizationDto org = this.wsSupport.findOrganization(dbSession, wsRequest.param("organization"));
            SearchTemplatesRequest request = new SearchTemplatesRequest().setOrganizationUuid(org.getUuid()).setQuery(wsRequest.param("q"));
            PermissionPrivilegeChecker.checkGlobalAdmin(this.userSession, request.getOrganizationUuid());
            Permissions.SearchTemplatesWsResponse searchTemplatesWsResponse = this.buildResponse(this.load(dbSession, request));
            WsUtils.writeProtobuf((Message)searchTemplatesWsResponse, wsRequest, wsResponse);
        }
    }

    private static void buildDefaultTemplatesResponse(Permissions.SearchTemplatesWsResponse.Builder response, SearchTemplatesData data) {
        Permissions.SearchTemplatesWsResponse.TemplateIdQualifier.Builder templateUuidQualifierBuilder = Permissions.SearchTemplatesWsResponse.TemplateIdQualifier.newBuilder();
        DefaultTemplatesResolver.ResolvedDefaultTemplates resolvedDefaultTemplates = data.defaultTemplates();
        response.addDefaultTemplates(templateUuidQualifierBuilder.setQualifier("TRK").setTemplateId(resolvedDefaultTemplates.getProject()));
        resolvedDefaultTemplates.getApplication().ifPresent(viewDefaultTemplate -> response.addDefaultTemplates(templateUuidQualifierBuilder.clear().setQualifier("APP").setTemplateId(viewDefaultTemplate)));
        resolvedDefaultTemplates.getPortfolio().ifPresent(viewDefaultTemplate -> response.addDefaultTemplates(templateUuidQualifierBuilder.clear().setQualifier("VW").setTemplateId(viewDefaultTemplate)));
    }

    private void buildTemplatesResponse(Permissions.SearchTemplatesWsResponse.Builder response, SearchTemplatesData data) {
        Permissions.Permission.Builder permissionResponse = Permissions.Permission.newBuilder();
        Permissions.PermissionTemplate.Builder templateBuilder = Permissions.PermissionTemplate.newBuilder();
        for (PermissionTemplateDto templateDto : data.templates()) {
            templateBuilder.clear().setId(templateDto.getUuid()).setName(templateDto.getName()).setCreatedAt(DateUtils.formatDateTime((Date)templateDto.getCreatedAt())).setUpdatedAt(DateUtils.formatDateTime((Date)templateDto.getUpdatedAt()));
            Optional.ofNullable(templateDto.getKeyPattern()).ifPresent(arg_0 -> ((Permissions.PermissionTemplate.Builder)templateBuilder).setProjectKeyPattern(arg_0));
            Optional.ofNullable(templateDto.getDescription()).ifPresent(arg_0 -> ((Permissions.PermissionTemplate.Builder)templateBuilder).setDescription(arg_0));
            for (String permission : this.permissionService.getAllProjectPermissions()) {
                templateBuilder.addPermissions(permissionResponse.clear().setKey(permission).setUsersCount(data.userCount(templateDto.getId(), permission)).setGroupsCount(data.groupCount(templateDto.getId(), permission)).setWithProjectCreator(data.withProjectCreator(templateDto.getId(), permission)));
            }
            response.addPermissionTemplates(templateBuilder);
        }
    }

    private Permissions.SearchTemplatesWsResponse buildResponse(SearchTemplatesData data) {
        Permissions.SearchTemplatesWsResponse.Builder response = Permissions.SearchTemplatesWsResponse.newBuilder();
        this.buildTemplatesResponse(response, data);
        SearchTemplatesAction.buildDefaultTemplatesResponse(response, data);
        this.buildPermissionsResponse(response);
        return response.build();
    }

    private void buildPermissionsResponse(Permissions.SearchTemplatesWsResponse.Builder response) {
        Permissions.Permission.Builder permissionResponse = Permissions.Permission.newBuilder();
        for (String permissionKey : this.permissionService.getAllProjectPermissions()) {
            response.addPermissions(permissionResponse.clear().setKey(permissionKey).setName(this.i18nName(permissionKey)).setDescription(this.i18nDescriptionMessage(permissionKey)));
        }
    }

    private String i18nDescriptionMessage(String permissionKey) {
        return this.i18n.message(Locale.ENGLISH, PROPERTY_PREFIX + permissionKey + DESCRIPTION_SUFFIX, "", new Object[0]);
    }

    private String i18nName(String permissionKey) {
        return this.i18n.message(Locale.ENGLISH, PROPERTY_PREFIX + permissionKey, permissionKey, new Object[0]);
    }

    private SearchTemplatesData load(DbSession dbSession, SearchTemplatesRequest request) {
        SearchTemplatesData.Builder data = SearchTemplatesData.builder();
        List<PermissionTemplateDto> templates = this.searchTemplates(dbSession, request);
        List templateIds = Lists.transform(templates, PermissionTemplateDto::getId);
        DefaultTemplates defaultTemplates = (DefaultTemplates)WsUtils.checkFoundWithOptional(this.dbClient.organizationDao().getDefaultTemplates(dbSession, request.getOrganizationUuid()), "No Default templates for organization with uuid '%s'", request.getOrganizationUuid());
        DefaultTemplatesResolver.ResolvedDefaultTemplates resolvedDefaultTemplates = this.defaultTemplatesResolver.resolve(defaultTemplates);
        data.templates(templates).defaultTemplates(resolvedDefaultTemplates).userCountByTemplateIdAndPermission(this.userCountByTemplateIdAndPermission(dbSession, templateIds)).groupCountByTemplateIdAndPermission(this.groupCountByTemplateIdAndPermission(dbSession, templateIds)).withProjectCreatorByTemplateIdAndPermission(this.withProjectCreatorsByTemplateIdAndPermission(dbSession, templateIds));
        return data.build();
    }

    private List<PermissionTemplateDto> searchTemplates(DbSession dbSession, SearchTemplatesRequest request) {
        return this.dbClient.permissionTemplateDao().selectAll(dbSession, request.getOrganizationUuid(), request.getQuery());
    }

    private Table<Long, String, Integer> userCountByTemplateIdAndPermission(DbSession dbSession, List<Long> templateIds) {
        TreeBasedTable userCountByTemplateIdAndPermission = TreeBasedTable.create();
        this.dbClient.permissionTemplateDao().usersCountByTemplateIdAndPermission(dbSession, templateIds, arg_0 -> SearchTemplatesAction.lambda$userCountByTemplateIdAndPermission$2((Table)userCountByTemplateIdAndPermission, arg_0));
        return userCountByTemplateIdAndPermission;
    }

    private Table<Long, String, Integer> groupCountByTemplateIdAndPermission(DbSession dbSession, List<Long> templateIds) {
        TreeBasedTable userCountByTemplateIdAndPermission = TreeBasedTable.create();
        this.dbClient.permissionTemplateDao().groupsCountByTemplateIdAndPermission(dbSession, templateIds, arg_0 -> SearchTemplatesAction.lambda$groupCountByTemplateIdAndPermission$3((Table)userCountByTemplateIdAndPermission, arg_0));
        return userCountByTemplateIdAndPermission;
    }

    private Table<Long, String, Boolean> withProjectCreatorsByTemplateIdAndPermission(DbSession dbSession, List<Long> templateIds) {
        TreeBasedTable templatePermissionsByTemplateIdAndPermission = TreeBasedTable.create();
        List templatePermissions = this.dbClient.permissionTemplateCharacteristicDao().selectByTemplateIds(dbSession, templateIds);
        templatePermissions.stream().forEach(arg_0 -> SearchTemplatesAction.lambda$withProjectCreatorsByTemplateIdAndPermission$4((Table)templatePermissionsByTemplateIdAndPermission, arg_0));
        return templatePermissionsByTemplateIdAndPermission;
    }

    private static /* synthetic */ void lambda$withProjectCreatorsByTemplateIdAndPermission$4(Table templatePermissionsByTemplateIdAndPermission, PermissionTemplateCharacteristicDto templatePermission) {
        templatePermissionsByTemplateIdAndPermission.put((Object)templatePermission.getTemplateId(), (Object)templatePermission.getPermission(), (Object)templatePermission.getWithProjectCreator());
    }

    private static /* synthetic */ void lambda$groupCountByTemplateIdAndPermission$3(Table userCountByTemplateIdAndPermission, ResultContext context) {
        CountByTemplateAndPermissionDto row = (CountByTemplateAndPermissionDto)context.getResultObject();
        userCountByTemplateIdAndPermission.put((Object)row.getTemplateId(), (Object)row.getPermission(), (Object)row.getCount());
    }

    private static /* synthetic */ void lambda$userCountByTemplateIdAndPermission$2(Table userCountByTemplateIdAndPermission, ResultContext context) {
        CountByTemplateAndPermissionDto row = (CountByTemplateAndPermissionDto)context.getResultObject();
        userCountByTemplateIdAndPermission.put((Object)row.getTemplateId(), (Object)row.getPermission(), (Object)row.getCount());
    }

    private static class SearchTemplatesRequest {
        private String query;
        private String organizationUuid;

        private SearchTemplatesRequest() {
        }

        @CheckForNull
        public String getQuery() {
            return this.query;
        }

        public SearchTemplatesRequest setQuery(@Nullable String query) {
            this.query = query;
            return this;
        }

        public String getOrganizationUuid() {
            return this.organizationUuid;
        }

        public SearchTemplatesRequest setOrganizationUuid(String s) {
            this.organizationUuid = s;
            return this;
        }
    }
}

