/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.monitoring.cluster;

import org.elasticsearch.action.admin.cluster.stats.ClusterStatsResponse;
import org.sonar.api.server.ServerSide;
import org.sonar.process.systeminfo.Global;
import org.sonar.process.systeminfo.SystemInfoSection;
import org.sonar.process.systeminfo.SystemInfoUtils;
import org.sonar.process.systeminfo.protobuf.ProtobufSystemInfo;
import org.sonar.server.es.EsClient;

@ServerSide
public class EsClusterStateSection
implements SystemInfoSection,
Global {
    private final EsClient esClient;

    public EsClusterStateSection(EsClient esClient) {
        this.esClient = esClient;
    }

    public ProtobufSystemInfo.Section toProtobuf() {
        ProtobufSystemInfo.Section.Builder protobuf = ProtobufSystemInfo.Section.newBuilder();
        protobuf.setName("Search State");
        ClusterStatsResponse stats = (ClusterStatsResponse)this.esClient.prepareClusterStats().get();
        SystemInfoUtils.setAttribute((ProtobufSystemInfo.Section.Builder)protobuf, (String)"State", (String)stats.getStatus().name());
        SystemInfoUtils.setAttribute((ProtobufSystemInfo.Section.Builder)protobuf, (String)"Nodes", (long)stats.getNodesStats().getCounts().getTotal());
        return protobuf.build();
    }
}

