/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.ws;

import java.util.Arrays;
import java.util.List;
import org.sonar.api.utils.text.JsonWriter;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.process.systeminfo.SystemInfoSection;
import org.sonar.server.ce.http.CeHttpClient;
import org.sonar.server.health.Health;
import org.sonar.server.health.HealthChecker;
import org.sonar.server.platform.ws.SystemInfoWriter;
import org.sonar.server.telemetry.TelemetryDataLoader;

public class StandaloneSystemInfoWriter
extends SystemInfoWriter {
    private final CeHttpClient ceHttpClient;
    private final HealthChecker healthChecker;
    private final SystemInfoSection[] systemInfoSections;

    public StandaloneSystemInfoWriter(TelemetryDataLoader telemetry, CeHttpClient ceHttpClient, HealthChecker healthChecker, SystemInfoSection ... systemInfoSections) {
        super(telemetry);
        this.ceHttpClient = ceHttpClient;
        this.healthChecker = healthChecker;
        this.systemInfoSections = systemInfoSections;
    }

    @Override
    public void write(JsonWriter json) {
        this.writeHealth(json);
        List sections = (List)Arrays.stream(this.systemInfoSections).map(SystemInfoSection::toProtobuf).collect(MoreCollectors.toArrayList());
        this.ceHttpClient.retrieveSystemInfo().ifPresent(ce -> sections.addAll(ce.getSectionsList()));
        this.writeSections(sections, json);
        this.writeTelemetry(json);
    }

    private void writeHealth(JsonWriter json) {
        Health health = this.healthChecker.checkNode();
        this.writeHealth(health, json);
    }
}

