/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.plugins;

import com.google.common.base.Preconditions;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.jar.JarInputStream;
import java.util.jar.Pack200;
import java.util.zip.GZIPOutputStream;
import org.sonar.api.config.Configuration;
import org.sonar.api.server.ServerSide;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.api.utils.log.Profiler;
import org.sonar.core.platform.PluginInfo;
import org.sonar.server.plugins.InstalledPlugin;

@ServerSide
public class PluginFileSystem {
    public static final String PROPERTY_PLUGIN_COMPRESSION_ENABLE = "sonar.pluginsCompression.enable";
    private static final Logger LOG = Loggers.get(PluginFileSystem.class);
    private final Configuration configuration;
    private final Map<String, InstalledPlugin> installedFiles = new HashMap<String, InstalledPlugin>();

    public PluginFileSystem(Configuration configuration) {
        this.configuration = configuration;
    }

    public void addInstalledPlugin(PluginInfo plugin, File loadedJar) {
        Preconditions.checkState((!this.installedFiles.containsKey(plugin.getKey()) ? 1 : 0) != 0, (String)"Plugin %s is already loaded", (Object[])new Object[]{plugin.getKey()});
        Preconditions.checkState((boolean)loadedJar.exists(), (String)"loadedJar does not exist: %s", (Object[])new Object[]{loadedJar});
        Optional<File> compressed = this.compressJar(plugin, loadedJar);
        InstalledPlugin installedFile = new InstalledPlugin(plugin, new InstalledPlugin.FileAndMd5(loadedJar), compressed.map(InstalledPlugin.FileAndMd5::new).orElse(null));
        this.installedFiles.put(plugin.getKey(), installedFile);
    }

    public Optional<InstalledPlugin> getInstalledPlugin(String pluginKey) {
        return Optional.ofNullable(this.installedFiles.get(pluginKey));
    }

    public Collection<InstalledPlugin> getInstalledFiles() {
        return this.installedFiles.values();
    }

    private Optional<File> compressJar(PluginInfo plugin, File jar) {
        if (!this.configuration.getBoolean(PROPERTY_PLUGIN_COMPRESSION_ENABLE).orElse(false).booleanValue()) {
            return Optional.empty();
        }
        Path targetPack200 = PluginFileSystem.getPack200Path(jar.toPath());
        Path sourcePack200Path = PluginFileSystem.getPack200Path(plugin.getNonNullJarFile().toPath());
        if (sourcePack200Path.toFile().exists()) {
            try {
                LOG.debug("Found pack200: " + sourcePack200Path);
                Files.copy(sourcePack200Path, targetPack200, new CopyOption[0]);
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to copy pack200 file from " + sourcePack200Path + " to " + targetPack200, e);
            }
        } else {
            PluginFileSystem.pack200(jar.toPath(), targetPack200, plugin.getKey());
        }
        return Optional.of(targetPack200.toFile());
    }

    private static void pack200(Path jarPath, Path toPack200Path, String pluginKey) {
        Profiler profiler = Profiler.create((Logger)LOG);
        profiler.startInfo("Compressing plugin " + pluginKey + " [pack200]");
        try (JarInputStream in = new JarInputStream(new BufferedInputStream(Files.newInputStream(jarPath, new OpenOption[0])));
             GZIPOutputStream out = new GZIPOutputStream(new BufferedOutputStream(Files.newOutputStream(toPack200Path, new OpenOption[0])));){
            Pack200.newPacker().pack(in, (OutputStream)out);
        }
        catch (IOException e) {
            throw new IllegalStateException(String.format("Fail to pack200 plugin [%s] '%s' to '%s'", pluginKey, jarPath, toPack200Path), e);
        }
        profiler.stopInfo();
    }

    private static Path getPack200Path(Path jar) {
        String jarFileName = jar.getFileName().toString();
        String filename = jarFileName.substring(0, jarFileName.length() - 3) + "pack.gz";
        return jar.resolveSibling(filename);
    }
}

