/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.qualityprofile;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.sonar.api.server.ServerSide;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.qualityprofile.ActiveRuleDto;
import org.sonar.db.qualityprofile.QProfileDto;
import org.sonar.server.exceptions.BadRequestException;
import org.sonar.server.qualityprofile.ActiveRuleChange;
import org.sonar.server.qualityprofile.BulkChangeResult;
import org.sonar.server.qualityprofile.QProfileReset;
import org.sonar.server.qualityprofile.RuleActivation;
import org.sonar.server.qualityprofile.RuleActivationContext;
import org.sonar.server.qualityprofile.RuleActivator;
import org.sonar.server.qualityprofile.index.ActiveRuleIndexer;

@ServerSide
public class QProfileResetImpl
implements QProfileReset {
    private final DbClient db;
    private final RuleActivator activator;
    private final ActiveRuleIndexer activeRuleIndexer;

    public QProfileResetImpl(DbClient db, RuleActivator activator, ActiveRuleIndexer activeRuleIndexer) {
        this.db = db;
        this.activator = activator;
        this.activeRuleIndexer = activeRuleIndexer;
    }

    @Override
    public BulkChangeResult reset(DbSession dbSession, QProfileDto profile, Collection<RuleActivation> activations) {
        Objects.requireNonNull(profile.getId(), "Quality profile must be persisted");
        Preconditions.checkArgument((!profile.isBuiltIn() ? 1 : 0) != 0, (String)"Operation forbidden for built-in Quality Profile '%s'", (Object[])new Object[]{profile.getKee()});
        BulkChangeResult result = new BulkChangeResult();
        HashSet<Integer> rulesToBeDeactivated = new HashSet<Integer>();
        for (ActiveRuleDto activeRuleDto : this.db.activeRuleDao().selectByProfile(dbSession, profile)) {
            if (activeRuleDto.getInheritance() != null) continue;
            rulesToBeDeactivated.add(activeRuleDto.getRuleId());
        }
        HashSet<Integer> ruleIds = new HashSet<Integer>(rulesToBeDeactivated.size() + activations.size());
        ruleIds.addAll(rulesToBeDeactivated);
        activations.forEach(a -> ruleIds.add(a.getRuleId()));
        RuleActivationContext context = this.activator.createContextForUserProfile(dbSession, profile, ruleIds);
        for (RuleActivation activation : activations) {
            try {
                List<ActiveRuleChange> changes = this.activator.activate(dbSession, activation, context);
                rulesToBeDeactivated.remove(activation.getRuleId());
                result.incrementSucceeded();
                result.addChanges(changes);
            }
            catch (BadRequestException e) {
                result.incrementFailed();
                result.getErrors().addAll(e.errors());
            }
        }
        ArrayList<ActiveRuleChange> changes = new ArrayList<ActiveRuleChange>(result.getChanges());
        for (Integer ruleId : rulesToBeDeactivated) {
            try {
                changes.addAll(this.activator.deactivate(dbSession, context, ruleId, false));
            }
            catch (BadRequestException badRequestException) {}
        }
        this.activeRuleIndexer.commitAndIndex(dbSession, changes);
        return result;
    }
}

