/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.qualityprofile.ws;

import com.google.protobuf.Message;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.sonar.api.resources.Languages;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.db.qualityprofile.ActiveRuleCountQuery;
import org.sonar.db.qualityprofile.ActiveRuleDao;
import org.sonar.db.qualityprofile.QProfileDto;
import org.sonar.server.qualityprofile.ws.QProfileReference;
import org.sonar.server.qualityprofile.ws.QProfileWsAction;
import org.sonar.server.qualityprofile.ws.QProfileWsSupport;
import org.sonar.server.ws.WsUtils;
import org.sonarqube.ws.Qualityprofiles;

public class InheritanceAction
implements QProfileWsAction {
    private final DbClient dbClient;
    private final QProfileWsSupport wsSupport;
    private final Languages languages;

    public InheritanceAction(DbClient dbClient, QProfileWsSupport wsSupport, Languages languages) {
        this.dbClient = dbClient;
        this.wsSupport = wsSupport;
        this.languages = languages;
    }

    public void define(WebService.NewController context) {
        WebService.NewAction inheritance = context.createAction("inheritance").setSince("5.2").setDescription("Show a quality profile's ancestors and children.").setHandler((RequestHandler)this).setResponseExample(this.getClass().getResource("inheritance-example.json"));
        QProfileWsSupport.createOrganizationParam(inheritance).setSince("6.4");
        QProfileReference.defineParams(inheritance, this.languages);
    }

    public void handle(Request request, Response response) throws Exception {
        QProfileReference reference = QProfileReference.from(request);
        try (DbSession dbSession = this.dbClient.openSession(false);){
            QProfileDto profile = this.wsSupport.getProfile(dbSession, reference);
            OrganizationDto organization = this.wsSupport.getOrganization(dbSession, profile);
            List<QProfileDto> ancestors = this.ancestors(profile, dbSession);
            List children = this.dbClient.qualityProfileDao().selectChildren(dbSession, Collections.singleton(profile));
            ArrayList<QProfileDto> allProfiles = new ArrayList<QProfileDto>();
            allProfiles.add(profile);
            allProfiles.addAll(ancestors);
            allProfiles.addAll(children);
            Statistics statistics = new Statistics(dbSession, organization, allProfiles);
            WsUtils.writeProtobuf((Message)InheritanceAction.buildResponse(profile, ancestors, children, statistics), request, response);
        }
    }

    private List<QProfileDto> ancestors(QProfileDto profile, DbSession dbSession) {
        ArrayList<QProfileDto> ancestors = new ArrayList<QProfileDto>();
        this.collectAncestors(profile, ancestors, dbSession);
        return ancestors;
    }

    private void collectAncestors(QProfileDto profile, List<QProfileDto> ancestors, DbSession session) {
        if (profile.getParentKee() == null) {
            return;
        }
        QProfileDto parent = this.getParent(session, profile);
        ancestors.add(parent);
        this.collectAncestors(parent, ancestors, session);
    }

    private QProfileDto getParent(DbSession dbSession, QProfileDto profile) {
        QProfileDto parent = this.dbClient.qualityProfileDao().selectByUuid(dbSession, profile.getParentKee());
        if (parent == null) {
            throw new IllegalStateException("Cannot find parent of profile: " + profile.getKee());
        }
        return parent;
    }

    private static Qualityprofiles.InheritanceWsResponse buildResponse(QProfileDto profile, List<QProfileDto> ancestors, List<QProfileDto> children, Statistics statistics) {
        return Qualityprofiles.InheritanceWsResponse.newBuilder().setProfile(InheritanceAction.buildProfile(profile, statistics)).addAllAncestors(InheritanceAction.buildAncestors(ancestors, statistics)).addAllChildren(InheritanceAction.buildChildren(children, statistics)).build();
    }

    private static Iterable<Qualityprofiles.InheritanceWsResponse.QualityProfile> buildAncestors(List<QProfileDto> ancestors, Statistics statistics) {
        return ancestors.stream().map(ancestor -> InheritanceAction.buildProfile(ancestor, statistics)).collect(Collectors.toList());
    }

    private static Iterable<Qualityprofiles.InheritanceWsResponse.QualityProfile> buildChildren(List<QProfileDto> children, Statistics statistics) {
        return children.stream().map(child -> InheritanceAction.buildProfile(child, statistics)).collect(Collectors.toList());
    }

    private static Qualityprofiles.InheritanceWsResponse.QualityProfile buildProfile(QProfileDto qualityProfile, Statistics statistics) {
        String key = qualityProfile.getKee();
        Qualityprofiles.InheritanceWsResponse.QualityProfile.Builder builder = Qualityprofiles.InheritanceWsResponse.QualityProfile.newBuilder().setKey(key).setName(qualityProfile.getName()).setActiveRuleCount(statistics.countRulesByProfileKey.getOrDefault(key, 0L).longValue()).setOverridingRuleCount(statistics.countOverridingRulesByProfileKey.getOrDefault(key, 0L).longValue()).setIsBuiltIn(qualityProfile.isBuiltIn());
        Optional.ofNullable(qualityProfile.getParentKee()).ifPresent(arg_0 -> ((Qualityprofiles.InheritanceWsResponse.QualityProfile.Builder)builder).setParent(arg_0));
        return builder.build();
    }

    private class Statistics {
        private final Map<String, Long> countRulesByProfileKey;
        private final Map<String, Long> countOverridingRulesByProfileKey;

        private Statistics(DbSession dbSession, OrganizationDto organization, List<QProfileDto> profiles) {
            ActiveRuleDao dao = InheritanceAction.this.dbClient.activeRuleDao();
            ActiveRuleCountQuery.Builder builder = ActiveRuleCountQuery.builder().setOrganization(organization);
            this.countRulesByProfileKey = dao.countActiveRulesByQuery(dbSession, builder.setProfiles(profiles).build());
            this.countOverridingRulesByProfileKey = dao.countActiveRulesByQuery(dbSession, builder.setProfiles(profiles).setInheritance("OVERRIDES").build());
        }
    }
}

