/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.qualityprofile.ws;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.resources.Language;
import org.sonar.api.resources.Languages;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.WebService;
import org.sonar.core.util.stream.MoreCollectors;

public class QProfileReference {
    private final Type type;
    private final String key;
    private final String organizationKey;
    private final String language;
    private final String name;

    private QProfileReference(Type type, @Nullable String key, @Nullable String organizationKey, @Nullable String language, @Nullable String name) {
        this.type = type;
        if (type == Type.KEY) {
            this.key = Objects.requireNonNull(key);
            this.organizationKey = null;
            this.language = null;
            this.name = null;
        } else {
            this.key = null;
            this.organizationKey = organizationKey;
            this.language = Objects.requireNonNull(language);
            this.name = Objects.requireNonNull(name);
        }
    }

    public boolean hasKey() {
        return this.type == Type.KEY;
    }

    public String getKey() {
        Preconditions.checkState((this.key != null ? 1 : 0) != 0, (Object)"Key is not defined. Please call hasKey().");
        return this.key;
    }

    public Optional<String> getOrganizationKey() {
        Preconditions.checkState((this.type == Type.NAME ? 1 : 0) != 0, (Object)"Organization is not defined. Please call hasKey().");
        return Optional.ofNullable(this.organizationKey);
    }

    public String getLanguage() {
        Preconditions.checkState((this.type == Type.NAME ? 1 : 0) != 0, (Object)"Language is not defined. Please call hasKey().");
        return this.language;
    }

    public String getName() {
        Preconditions.checkState((this.type == Type.NAME ? 1 : 0) != 0, (Object)"Name is not defined. Please call hasKey().");
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QProfileReference that = (QProfileReference)o;
        if (this.key != null ? !this.key.equals(that.key) : that.key != null) {
            return false;
        }
        if (this.organizationKey != null ? !this.organizationKey.equals(that.organizationKey) : that.organizationKey != null) {
            return false;
        }
        if (this.language != null ? !this.language.equals(that.language) : that.language != null) {
            return false;
        }
        return this.name != null ? this.name.equals(that.name) : that.name == null;
    }

    public int hashCode() {
        int result = this.key != null ? this.key.hashCode() : 0;
        result = 31 * result + (this.organizationKey != null ? this.organizationKey.hashCode() : 0);
        result = 31 * result + (this.language != null ? this.language.hashCode() : 0);
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        return result;
    }

    public static QProfileReference from(Request request) {
        String key = request.param("key");
        String organizationKey = request.param("organization");
        String lang = request.param("language");
        String name = request.param("qualityProfile");
        return QProfileReference.from(key, organizationKey, lang, name);
    }

    public static QProfileReference from(@Nullable String key, @Nullable String organizationKey, @Nullable String lang, @Nullable String name) {
        if (key != null) {
            Preconditions.checkArgument((StringUtils.isEmpty((String)organizationKey) && StringUtils.isEmpty((String)lang) && StringUtils.isEmpty((String)name) ? 1 : 0) != 0, (String)"When a quality profile key is set, '%s' '%s' and '%s' can't be set", (Object[])new Object[]{"organization", "language", "qualityProfile"});
            return QProfileReference.fromKey(key);
        }
        Preconditions.checkArgument((!StringUtils.isEmpty((String)lang) && !StringUtils.isEmpty((String)name) ? 1 : 0) != 0, (String)"If '%s' is not specified, '%s' and '%s' must be set", (Object[])new Object[]{"key", "qualityProfile", "language"});
        return QProfileReference.fromName(organizationKey, lang, name);
    }

    public static QProfileReference fromKey(String key) {
        return new QProfileReference(Type.KEY, key, null, null, null);
    }

    public static QProfileReference fromName(@Nullable String organizationKey, String lang, String name) {
        return new QProfileReference(Type.NAME, null, organizationKey, Objects.requireNonNull(lang), Objects.requireNonNull(name));
    }

    public static void defineParams(WebService.NewAction action, Languages languages) {
        action.createParam("key").setDescription("Quality profile key. Mandatory unless 'qualityProfile' and 'language' are specified.").setDeprecatedKey("profileKey", "6.5").setDeprecatedSince("6.6").setExampleValue((Object)"AU-Tpxb--iU5OvuD2FLy");
        action.createParam("qualityProfile").setDescription("Quality profile name. Mandatory if 'key' is not set.").setDeprecatedKey("profileName", "6.6").setExampleValue((Object)"Sonar way");
        action.createParam("language").setDescription("Quality profile language. Mandatory if 'key' is not set.").setPossibleValues((Collection)Arrays.stream(languages.all()).map(Language::getKey).collect(MoreCollectors.toSet()));
    }

    private static enum Type {
        KEY,
        NAME;

    }
}

