/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.root.ws;

import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.user.UserDto;
import org.sonar.server.exceptions.NotFoundException;
import org.sonar.server.root.ws.RootsWsAction;
import org.sonar.server.user.UserSession;

public class SetRootAction
implements RootsWsAction {
    private static final String PARAM_LOGIN = "login";
    private final UserSession userSession;
    private final DbClient dbClient;

    public SetRootAction(UserSession userSession, DbClient dbClient) {
        this.userSession = userSession;
        this.dbClient = dbClient;
    }

    public void define(WebService.NewController controller) {
        WebService.NewAction action = controller.createAction("set_root").setInternal(true).setPost(true).setDescription("Make the specified user root.<br/>Requires to be root.").setSince("6.2").setHandler((RequestHandler)this);
        action.createParam(PARAM_LOGIN).setDescription("A user login").setExampleValue((Object)"admin").setRequired(true).setSince("6.2");
    }

    public void handle(Request request, Response response) throws Exception {
        this.userSession.checkIsRoot();
        String login = request.mandatoryParam(PARAM_LOGIN);
        try (DbSession dbSession = this.dbClient.openSession(false);){
            UserDto userDto = this.dbClient.userDao().selectByLogin(dbSession, login);
            if (userDto == null || !userDto.isActive()) {
                throw new NotFoundException(String.format("User with login '%s' not found", login));
            }
            if (!userDto.isRoot()) {
                this.dbClient.userDao().setRoot(dbSession, login, true);
                dbSession.commit();
            }
        }
        response.noContent();
    }
}

