/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.user;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.web.UserRole;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.db.permission.OrganizationPermission;
import org.sonar.db.user.GroupDto;
import org.sonar.db.user.UserDto;
import org.sonar.server.organization.DefaultOrganizationProvider;
import org.sonar.server.organization.OrganizationFlags;
import org.sonar.server.user.AbstractUserSession;
import org.sonar.server.user.UserSession;

public class ServerUserSession
extends AbstractUserSession {
    @CheckForNull
    private final UserDto userDto;
    private final DbClient dbClient;
    private final OrganizationFlags organizationFlags;
    private final DefaultOrganizationProvider defaultOrganizationProvider;
    private final Supplier<Collection<GroupDto>> groups = Suppliers.memoize(this::loadGroups);
    private final Supplier<Boolean> isSystemAdministratorSupplier = Suppliers.memoize(this::loadIsSystemAdministrator);
    private final Map<String, String> projectUuidByComponentUuid = new HashMap<String, String>();
    private Map<String, Set<OrganizationPermission>> permissionsByOrganizationUuid;
    private Map<String, Set<String>> permissionsByProjectUuid;
    private Set<String> organizationMembership = new HashSet<String>();

    ServerUserSession(DbClient dbClient, OrganizationFlags organizationFlags, DefaultOrganizationProvider defaultOrganizationProvider, @Nullable UserDto userDto) {
        this.dbClient = dbClient;
        this.organizationFlags = organizationFlags;
        this.defaultOrganizationProvider = defaultOrganizationProvider;
        this.userDto = userDto;
    }

    private Collection<GroupDto> loadGroups() {
        if (this.userDto == null) {
            return Collections.emptyList();
        }
        try (DbSession dbSession = this.dbClient.openSession(false);){
            List list = this.dbClient.groupDao().selectByUserLogin(dbSession, this.userDto.getLogin());
            return list;
        }
    }

    @Override
    @CheckForNull
    public String getLogin() {
        return this.userDto == null ? null : this.userDto.getLogin();
    }

    @Override
    @CheckForNull
    public String getUuid() {
        return this.userDto == null ? null : this.userDto.getUuid();
    }

    @Override
    @CheckForNull
    public String getName() {
        return this.userDto == null ? null : this.userDto.getName();
    }

    @Override
    @CheckForNull
    public Integer getUserId() {
        return this.userDto == null ? null : this.userDto.getId();
    }

    @Override
    public Collection<GroupDto> getGroups() {
        return (Collection)this.groups.get();
    }

    @Override
    public boolean isLoggedIn() {
        return this.userDto != null;
    }

    @Override
    public boolean isRoot() {
        return this.userDto != null && this.userDto.isRoot();
    }

    @Override
    public Optional<UserSession.IdentityProvider> getIdentityProvider() {
        return Optional.ofNullable(this.userDto).map(d -> ServerUserSession.computeIdentity(d).getIdentityProvider());
    }

    @Override
    public Optional<UserSession.ExternalIdentity> getExternalIdentity() {
        return Optional.ofNullable(this.userDto).map(d -> ServerUserSession.computeIdentity(d).getExternalIdentity());
    }

    @Override
    public Optional<String> getPersonalOrganizationUuid() {
        return Optional.ofNullable(this.userDto).map(UserDto::getOrganizationUuid);
    }

    @Override
    protected boolean hasPermissionImpl(OrganizationPermission permission, String organizationUuid) {
        if (this.permissionsByOrganizationUuid == null) {
            this.permissionsByOrganizationUuid = new HashMap<String, Set<OrganizationPermission>>();
        }
        Set permissions = this.permissionsByOrganizationUuid.computeIfAbsent(organizationUuid, this::loadOrganizationPermissions);
        return permissions.contains(permission);
    }

    private Set<OrganizationPermission> loadOrganizationPermissions(String organizationUuid) {
        Set permissionKeys;
        try (DbSession dbSession = this.dbClient.openSession(false);){
            permissionKeys = this.userDto != null && this.userDto.getId() != null ? this.dbClient.authorizationDao().selectOrganizationPermissions(dbSession, organizationUuid, this.userDto.getId().intValue()) : this.dbClient.authorizationDao().selectOrganizationPermissionsOfAnonymous(dbSession, organizationUuid);
        }
        return (Set)permissionKeys.stream().map(OrganizationPermission::fromKey).collect(MoreCollectors.toSet((int)permissionKeys.size()));
    }

    @Override
    protected Optional<String> componentUuidToProjectUuid(String componentUuid) {
        String projectUuid = this.projectUuidByComponentUuid.get(componentUuid);
        if (projectUuid != null) {
            return Optional.of(projectUuid);
        }
        try (DbSession dbSession = this.dbClient.openSession(false);){
            Optional component = this.dbClient.componentDao().selectByUuid(dbSession, componentUuid);
            if (!component.isPresent()) {
                Optional<String> optional = Optional.empty();
                return optional;
            }
            projectUuid = StringUtils.defaultIfEmpty((String)((ComponentDto)component.get()).getMainBranchProjectUuid(), (String)((ComponentDto)component.get()).projectUuid());
            this.projectUuidByComponentUuid.put(componentUuid, projectUuid);
            Optional<String> optional = Optional.of(projectUuid);
            return optional;
        }
    }

    @Override
    protected boolean hasProjectUuidPermission(String permission, String projectUuid) {
        if (this.permissionsByProjectUuid == null) {
            this.permissionsByProjectUuid = new HashMap<String, Set<String>>();
        }
        Set permissions = this.permissionsByProjectUuid.computeIfAbsent(projectUuid, this::loadProjectPermissions);
        return permissions.contains(permission);
    }

    private Set<String> loadProjectPermissions(String projectUuid) {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            Optional component = this.dbClient.componentDao().selectByUuid(dbSession, projectUuid);
            if (!component.isPresent()) {
                Set<String> set = Collections.emptySet();
                return set;
            }
            if (((ComponentDto)component.get()).isPrivate()) {
                Set<String> set = this.loadDbPermissions(dbSession, projectUuid);
                return set;
            }
            ImmutableSet.Builder builder = ImmutableSet.builder();
            builder.addAll((Iterable)UserRole.PUBLIC_PERMISSIONS);
            builder.addAll(this.loadDbPermissions(dbSession, projectUuid));
            ImmutableSet immutableSet = builder.build();
            return immutableSet;
        }
    }

    private Set<String> loadDbPermissions(DbSession dbSession, String projectUuid) {
        if (this.userDto != null && this.userDto.getId() != null) {
            return this.dbClient.authorizationDao().selectProjectPermissions(dbSession, projectUuid, (long)this.userDto.getId().intValue());
        }
        return this.dbClient.authorizationDao().selectProjectPermissionsOfAnonymous(dbSession, projectUuid);
    }

    @Override
    protected List<ComponentDto> doKeepAuthorizedComponents(String permission, Collection<ComponentDto> components) {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            Set projectUuids = (Set)components.stream().map(c -> StringUtils.defaultIfEmpty((String)c.getMainBranchProjectUuid(), (String)c.projectUuid())).collect(MoreCollectors.toSet((int)components.size()));
            Set authorizedProjectUuids = this.dbClient.authorizationDao().keepAuthorizedProjectUuids(dbSession, (Collection)projectUuids, this.getUserId(), permission);
            List list = (List)components.stream().filter(c -> authorizedProjectUuids.contains(c.projectUuid()) || authorizedProjectUuids.contains(c.getMainBranchProjectUuid())).collect(MoreCollectors.toList((int)components.size()));
            return list;
        }
    }

    @Override
    public boolean isSystemAdministrator() {
        return (Boolean)this.isSystemAdministratorSupplier.get();
    }

    private boolean loadIsSystemAdministrator() {
        if (this.isRoot()) {
            return true;
        }
        try (DbSession dbSession = this.dbClient.openSession(false);){
            if (!this.organizationFlags.isEnabled(dbSession)) {
                String uuidOfDefaultOrg = this.defaultOrganizationProvider.get().getUuid();
                boolean bl = this.hasPermission(OrganizationPermission.ADMINISTER, uuidOfDefaultOrg);
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    @Override
    public boolean hasMembershipImpl(OrganizationDto organizationDto) {
        return this.isMember(organizationDto.getUuid());
    }

    private boolean isMember(String organizationUuid) {
        if (!this.isLoggedIn()) {
            return false;
        }
        if (this.isRoot()) {
            return true;
        }
        if (this.organizationMembership.contains(organizationUuid)) {
            return true;
        }
        try (DbSession dbSession = this.dbClient.openSession(false);){
            Optional organizationMemberDto = this.dbClient.organizationMemberDao().select(dbSession, organizationUuid, Objects.requireNonNull(this.getUserId()).intValue());
            if (organizationMemberDto.isPresent()) {
                this.organizationMembership.add(organizationUuid);
            }
            boolean bl = this.organizationMembership.contains(organizationUuid);
            return bl;
        }
    }
}

