/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.usergroups.ws;

import com.google.protobuf.Message;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.api.user.UserGroupValidation;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.db.permission.OrganizationPermission;
import org.sonar.db.user.GroupDto;
import org.sonar.server.user.UserSession;
import org.sonar.server.usergroups.ws.GroupWsSupport;
import org.sonar.server.usergroups.ws.UserGroupsWsAction;
import org.sonar.server.ws.WsUtils;
import org.sonarqube.ws.UserGroups;

public class CreateAction
implements UserGroupsWsAction {
    private final DbClient dbClient;
    private final UserSession userSession;
    private final GroupWsSupport support;

    public CreateAction(DbClient dbClient, UserSession userSession, GroupWsSupport support) {
        this.dbClient = dbClient;
        this.userSession = userSession;
        this.support = support;
    }

    public void define(WebService.NewController controller) {
        WebService.NewAction action = controller.createAction("create").setDescription("Create a group.<br>Requires the following permission: 'Administer System'.").setHandler((RequestHandler)this).setPost(true).setResponseExample(this.getClass().getResource("create-example.json")).setSince("5.2");
        action.createParam("organization").setDescription("Key of organization. If unset then default organization is used.").setExampleValue((Object)"my-org").setSince("6.2").setInternal(true);
        action.createParam("name").setRequired(true).setMaximumLength(Integer.valueOf(255)).setDescription(String.format("Name for the new group. A group name cannot be larger than %d characters and must be unique. The value 'anyone' (whatever the case) is reserved and cannot be used.", 255)).setExampleValue((Object)"sonar-users");
        action.createParam("description").setMaximumLength(Integer.valueOf(200)).setDescription(String.format("Description for the new group. A group description cannot be larger than %d characters.", 200)).setExampleValue((Object)"Default group for new users");
    }

    public void handle(Request request, Response response) throws Exception {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            OrganizationDto organization = this.support.findOrganizationByKey(dbSession, request.param("organization"));
            this.userSession.checkPermission(OrganizationPermission.ADMINISTER, organization);
            GroupDto group = new GroupDto().setOrganizationUuid(organization.getUuid()).setName(request.mandatoryParam("name")).setDescription(request.param("description"));
            UserGroupValidation.validateGroupName((String)group.getName());
            this.support.checkNameDoesNotExist(dbSession, group.getOrganizationUuid(), group.getName());
            this.dbClient.groupDao().insert(dbSession, group);
            dbSession.commit();
            this.writeResponse(request, response, organization, group);
        }
    }

    private void writeResponse(Request request, Response response, OrganizationDto organization, GroupDto group) {
        UserGroups.CreateWsResponse.Builder respBuilder = UserGroups.CreateWsResponse.newBuilder();
        respBuilder.setGroup(GroupWsSupport.toProtobuf(organization, group, 0, false));
        WsUtils.writeProtobuf((Message)respBuilder.build(), request, response);
    }
}

