/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.usergroups.ws;

import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.permission.OrganizationPermission;
import org.sonar.db.user.GroupDto;
import org.sonar.db.user.UserDto;
import org.sonar.server.user.UserSession;
import org.sonar.server.usergroups.ws.GroupWsSupport;
import org.sonar.server.usergroups.ws.UserGroupsWsAction;
import org.sonar.server.ws.WsUtils;

public class RemoveUserAction
implements UserGroupsWsAction {
    private final DbClient dbClient;
    private final UserSession userSession;
    private final GroupWsSupport support;

    public RemoveUserAction(DbClient dbClient, UserSession userSession, GroupWsSupport support) {
        this.dbClient = dbClient;
        this.userSession = userSession;
        this.support = support;
    }

    public void define(WebService.NewController context) {
        WebService.NewAction action = context.createAction("remove_user").setDescription(String.format("Remove a user from a group.<br />'%s' or '%s' must be provided.<br>Requires the following permission: 'Administer System'.", "id", "name")).setHandler((RequestHandler)this).setPost(true).setSince("5.2");
        GroupWsSupport.defineGroupWsParameters(action);
        GroupWsSupport.defineLoginWsParameter(action);
    }

    public void handle(Request request, Response response) throws Exception {
        this.userSession.checkLoggedIn();
        try (DbSession dbSession = this.dbClient.openSession(false);){
            GroupDto group = this.support.findGroupDto(dbSession, request);
            this.userSession.checkPermission(OrganizationPermission.ADMINISTER, group.getOrganizationUuid());
            this.support.checkGroupIsNotDefault(dbSession, group);
            String login = request.mandatoryParam("login");
            UserDto user = this.getUser(dbSession, login);
            this.ensureLastAdminIsNotRemoved(dbSession, group, user);
            this.dbClient.userGroupDao().delete(dbSession, group.getId().intValue(), user.getId().intValue());
            dbSession.commit();
            response.noContent();
        }
    }

    private void ensureLastAdminIsNotRemoved(DbSession dbSession, GroupDto group, UserDto user) {
        int remainingAdmins = this.dbClient.authorizationDao().countUsersWithGlobalPermissionExcludingGroupMember(dbSession, group.getOrganizationUuid(), OrganizationPermission.ADMINISTER.getKey(), group.getId().intValue(), user.getId().intValue());
        WsUtils.checkRequest(remainingAdmins > 0, "The last administrator user cannot be removed", new Object[0]);
    }

    private UserDto getUser(DbSession dbSession, String userLogin) {
        return WsUtils.checkFound(this.dbClient.userDao().selectActiveUserByLogin(dbSession, userLogin), "User with login '%s' is not found'", userLogin);
    }
}

