/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.ws;

import java.util.Collection;
import java.util.Date;
import javax.annotation.Nullable;
import org.sonar.api.utils.text.JsonWriter;

public class JsonWriterUtils {
    private JsonWriterUtils() {
    }

    public static void writeIfNeeded(JsonWriter json, @Nullable String value, String field, @Nullable Collection<String> fields) {
        if (JsonWriterUtils.isFieldNeeded(field, fields)) {
            json.prop(field, value);
        }
    }

    public static void writeIfNeeded(JsonWriter json, @Nullable Boolean value, String field, @Nullable Collection<String> fields) {
        if (JsonWriterUtils.isFieldNeeded(field, fields)) {
            json.prop(field, value.booleanValue());
        }
    }

    public static void writeIfNeeded(JsonWriter json, @Nullable Integer value, String field, @Nullable Collection<String> fields) {
        if (JsonWriterUtils.isFieldNeeded(field, fields)) {
            json.prop(field, (Number)value);
        }
    }

    public static void writeIfNeeded(JsonWriter json, @Nullable Long value, String field, @Nullable Collection<String> fields) {
        if (JsonWriterUtils.isFieldNeeded(field, fields)) {
            json.prop(field, (Number)value);
        }
    }

    public static void writeIfNeeded(JsonWriter json, @Nullable Date value, String field, @Nullable Collection<String> fields) {
        if (JsonWriterUtils.isFieldNeeded(field, fields)) {
            json.propDateTime(field, value);
        }
    }

    public static boolean isFieldNeeded(String field, @Nullable Collection<String> fields) {
        return fields == null || fields.isEmpty() || fields.contains(field);
    }
}

