/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.ws;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.sonar.api.server.ws.LocalConnector;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.internal.ValidatingRequest;

public class LocalRequestAdapter
extends ValidatingRequest {
    private final LocalConnector.LocalRequest localRequest;

    public LocalRequestAdapter(LocalConnector.LocalRequest localRequest) {
        this.localRequest = localRequest;
    }

    protected String readParam(String key) {
        return this.localRequest.getParam(key);
    }

    public Map<String, String[]> getParams() {
        return this.localRequest.getParameterMap();
    }

    protected List<String> readMultiParam(String key) {
        return this.localRequest.getMultiParam(key);
    }

    protected InputStream readInputStreamParam(String key) {
        String value = this.readParam(key);
        if (value == null) {
            return null;
        }
        return new ByteArrayInputStream(value.getBytes(StandardCharsets.UTF_8));
    }

    protected Request.Part readPart(String key) {
        throw new UnsupportedOperationException("reading part is not supported yet by local WS calls");
    }

    public boolean hasParam(String key) {
        return this.localRequest.hasParam(key);
    }

    public String getPath() {
        return this.localRequest.getPath();
    }

    public String method() {
        return this.localRequest.getMethod();
    }

    public String getMediaType() {
        return this.localRequest.getMediaType();
    }

    public Optional<String> header(String name) {
        return this.localRequest.getHeader(name);
    }
}

